/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import org.cp.elements.data.conversion.DefaultableConverter;
import org.cp.elements.lang.ElementsExceptionsFactory;
import org.cp.elements.lang.StringUtils;

public class IntegerConverter
extends DefaultableConverter<Object, Integer> {
    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return this.isAssignableTo(fromType, Number.class, String.class) && Integer.class.equals(toType);
    }

    @Override
    public Integer convert(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String && StringUtils.containsDigits(value.toString().trim())) {
            try {
                return Integer.parseInt(value.toString().trim());
            }
            catch (NumberFormatException cause) {
                throw ElementsExceptionsFactory.newConversionException(cause, "[%s] is not a valid Integer", value);
            }
        }
        return (Integer)super.convert(value);
    }
}

