/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import java.util.Calendar;
import java.util.Date;
import org.cp.elements.data.conversion.DefaultableConverter;
import org.cp.elements.lang.ElementsExceptionsFactory;
import org.cp.elements.lang.StringUtils;

public class LongConverter
extends DefaultableConverter<Object, Long> {
    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return this.isAssignableTo(fromType, Number.class, Calendar.class, Date.class, String.class) && Long.class.equals(toType);
    }

    @Override
    public Long convert(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTimeInMillis();
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof String && StringUtils.containsDigits(value.toString().trim())) {
            try {
                return Long.parseLong(value.toString().trim());
            }
            catch (NumberFormatException cause) {
                throw ElementsExceptionsFactory.newConversionException(cause, "[%s] is not a valid Long", value);
            }
        }
        return (Long)super.convert(value);
    }
}

