/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.cp.elements.data.conversion.AbstractConverter;
import org.cp.elements.data.conversion.ConversionException;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ElementsExceptionsFactory;
import org.cp.elements.lang.StringUtils;

public class NumberConverter
extends AbstractConverter<Object, Number> {
    protected static final String CONVERSION_EXCEPTION_MESSAGE = "[%1$s] is not a valid number of the qualifying type [%2$s]";

    protected <QT extends Number> QT parseNumber(String number, Class<QT> numberType) {
        if (AtomicInteger.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(new AtomicInteger(Integer.parseInt(number))));
        }
        if (AtomicLong.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(new AtomicLong(Long.parseLong(number))));
        }
        if (BigDecimal.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(new BigDecimal(number)));
        }
        if (BigInteger.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(new BigInteger(number)));
        }
        if (Byte.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(Byte.parseByte(number)));
        }
        if (Short.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(Short.parseShort(number)));
        }
        if (Integer.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(Integer.parseInt(number)));
        }
        if (Long.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(Long.parseLong(number)));
        }
        if (Float.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(Float.valueOf(Float.parseFloat(number))));
        }
        if (Double.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(Double.parseDouble(number)));
        }
        throw ElementsExceptionsFactory.newConversionException("[%s] is not a valid Number type", numberType.getName());
    }

    protected <QT extends Number> QT toQualifyingNumber(Number number, Class<QT> numberType) {
        if (AtomicInteger.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(new AtomicInteger(number.intValue())));
        }
        if (AtomicLong.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(new AtomicLong(number.longValue())));
        }
        if (BigDecimal.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(new BigDecimal(number.doubleValue())));
        }
        if (BigInteger.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(new BigInteger(number.toString())));
        }
        if (Byte.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(number.byteValue()));
        }
        if (Short.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(number.shortValue()));
        }
        if (Integer.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(number.intValue()));
        }
        if (Long.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(number.longValue()));
        }
        if (Float.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(Float.valueOf(number.floatValue())));
        }
        if (Double.class.isAssignableFrom(numberType)) {
            return (QT)((Number)numberType.cast(number.doubleValue()));
        }
        throw ElementsExceptionsFactory.newConversionException("[%s] is not a valid Number type", numberType.getName());
    }

    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return fromType != null && this.isAssignableTo(fromType, Number.class, String.class) && toType != null && Number.class.isAssignableFrom(toType);
    }

    @Override
    public <QT extends Number> QT convert(Object value, Class<QT> qualifyingType) {
        Assert.notNull(qualifyingType, "Qualifying type is required", new Object[0]);
        try {
            if (qualifyingType.isInstance(value)) {
                return (QT)((Number)qualifyingType.cast(value));
            }
            if (value instanceof Number) {
                return this.toQualifyingNumber((Number)value, qualifyingType);
            }
            if (value instanceof String && StringUtils.containsDigits(value.toString().trim())) {
                return this.parseNumber(value.toString().trim(), qualifyingType);
            }
            throw ElementsExceptionsFactory.newConversionException(CONVERSION_EXCEPTION_MESSAGE, value, qualifyingType.getName());
        }
        catch (Exception cause) {
            if (cause instanceof ConversionException) {
                throw (ConversionException)cause;
            }
            throw ElementsExceptionsFactory.newConversionException(cause, CONVERSION_EXCEPTION_MESSAGE, value, qualifyingType.getName());
        }
    }
}

