/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import org.cp.elements.data.conversion.DefaultableConverter;
import org.cp.elements.lang.ElementsExceptionsFactory;
import org.cp.elements.lang.StringUtils;

public class ShortConverter
extends DefaultableConverter<Object, Short> {
    protected static final String CONVERSION_EXCEPTION_MESSAGE = "[%s] is not a valid Short";

    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return this.isAssignableTo(fromType, Number.class, String.class) && Short.class.equals(toType);
    }

    @Override
    public Short convert(Object value) {
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String && StringUtils.containsDigits(value.toString().trim())) {
            try {
                return Short.parseShort(value.toString().trim());
            }
            catch (NumberFormatException cause) {
                throw ElementsExceptionsFactory.newConversionException(cause, CONVERSION_EXCEPTION_MESSAGE, value);
            }
        }
        return (Short)super.convert(value);
    }
}

