/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import java.net.URI;
import java.net.URL;
import org.cp.elements.data.conversion.AbstractConverter;
import org.cp.elements.data.conversion.ConversionException;
import org.cp.elements.lang.ElementsExceptionsFactory;

public class URIConverter
extends AbstractConverter<Object, URI> {
    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return fromType != null && this.isAssignableTo(fromType, URI.class, URL.class, String.class) && URI.class.equals(toType);
    }

    @Override
    public URI convert(Object value) {
        try {
            if (value instanceof URI) {
                return (URI)value;
            }
            if (value instanceof URL) {
                return ((URL)value).toURI();
            }
            if (value instanceof String) {
                return URI.create(value.toString().trim());
            }
            throw ElementsExceptionsFactory.newConversionException("[%s] is not a valid URI", value);
        }
        catch (Exception cause) {
            if (cause instanceof ConversionException) {
                throw (ConversionException)cause;
            }
            throw ElementsExceptionsFactory.newConversionException(cause, "[%s] is not a valid URI", value);
        }
    }
}

