/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.provider;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.cp.elements.data.conversion.AbstractConversionService;
import org.cp.elements.data.conversion.Converter;
import org.cp.elements.data.conversion.converters.BigDecimalConverter;
import org.cp.elements.data.conversion.converters.BigIntegerConverter;
import org.cp.elements.data.conversion.converters.BooleanConverter;
import org.cp.elements.data.conversion.converters.ByteConverter;
import org.cp.elements.data.conversion.converters.CharacterConverter;
import org.cp.elements.data.conversion.converters.DateConverter;
import org.cp.elements.data.conversion.converters.DoubleConverter;
import org.cp.elements.data.conversion.converters.EnumConverter;
import org.cp.elements.data.conversion.converters.FloatConverter;
import org.cp.elements.data.conversion.converters.IdentifiableConverter;
import org.cp.elements.data.conversion.converters.IntegerConverter;
import org.cp.elements.data.conversion.converters.LongConverter;
import org.cp.elements.data.conversion.converters.NumberConverter;
import org.cp.elements.data.conversion.converters.ShortConverter;
import org.cp.elements.data.conversion.converters.StringConverter;
import org.cp.elements.data.conversion.converters.URIConverter;
import org.cp.elements.data.conversion.converters.URLConverter;
import org.cp.elements.io.FileExtensionFilter;
import org.cp.elements.io.FileUtils;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.Identifiable;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.lang.RuntimeExceptionsFactory;
import org.cp.elements.util.CollectionUtils;

public class SimpleConversionService
extends AbstractConversionService {
    protected static final Class CONVERTER_CLASS = StringConverter.class;
    protected static final Package CONVERTERS_PACKAGE = CONVERTER_CLASS.getPackage();
    private volatile boolean defaultsEnabled = false;
    private final Map<Class, Object> defaultValues = Collections.synchronizedMap(new HashMap(13, 0.95f));

    public SimpleConversionService() {
        this.registerConverters();
        this.initDefaultValues();
    }

    private void registerConverters() {
        String converterClassResourceName = this.toResourceName(CONVERTER_CLASS);
        URL converterClassResourceLocation = this.resolveResourceLocation(converterClassResourceName);
        Assert.notNull(converterClassResourceLocation, "Could not resolve URL for Converter class [%1$s] having resource name [%2$s]", CONVERTER_CLASS.getName(), converterClassResourceName);
        try {
            if (this.isJarFile(converterClassResourceLocation)) {
                this.registerConvertersFromJarFile(converterClassResourceName, converterClassResourceLocation);
            } else {
                this.registerConvertersFromFileSystem(converterClassResourceName, converterClassResourceLocation);
            }
        }
        catch (Exception ignore) {
            this.registerConvertersFromPackage();
        }
    }

    private String toResourceName(Class<?> type) {
        return ObjectUtils.getResourceName(type);
    }

    private URL resolveResourceLocation(String resourceName) {
        return Thread.currentThread().getContextClassLoader().getResource(resourceName);
    }

    private boolean isJarFile(URL resourceLocation) {
        String resourceLocationString = resourceLocation.toExternalForm();
        return resourceLocationString.startsWith("jar:file:") || resourceLocationString.contains(".jar!");
    }

    private void registerConvertersFromPackage() {
        this.register(new BigDecimalConverter());
        this.register(new BigIntegerConverter());
        this.register(new BooleanConverter());
        this.register(new ByteConverter());
        this.register(new DateConverter());
        this.register(new CharacterConverter());
        this.register(new DoubleConverter());
        this.register(new EnumConverter());
        this.register(new FloatConverter());
        this.register(new IdentifiableConverter());
        this.register(new IntegerConverter());
        this.register(new LongConverter());
        this.register(new NumberConverter());
        this.register(new ShortConverter());
        this.register(new StringConverter());
        this.register(new URIConverter());
        this.register(new URLConverter());
    }

    private void registerConvertersFromJarFile(String converterClassResourceName, URL converterClassResourceLocation) {
        String converterClassResourceLocationString = converterClassResourceLocation.toExternalForm();
        String convertersPackageResourceName = CONVERTERS_PACKAGE.getName().replaceAll("\\.", "/");
        String jarFilePathname = converterClassResourceLocationString.contains(".jar!/") ? converterClassResourceLocationString.substring(0, converterClassResourceLocationString.indexOf(".jar!/")).concat(".jar") : converterClassResourceLocationString;
        jarFilePathname = jarFilePathname.startsWith("jar:file:") ? jarFilePathname.substring("jar:file:".length()) : jarFilePathname;
        try {
            JarFile jarFile = new JarFile(new File(jarFilePathname));
            for (JarEntry jarEntry : CollectionUtils.asIterable(jarFile.entries())) {
                String jarEntryName = jarEntry.getName();
                if (!jarEntryName.startsWith(convertersPackageResourceName) || !jarEntryName.endsWith(".class")) continue;
                String converterClassName = jarEntryName.replaceAll("/", ".");
                converterClassName = converterClassName.endsWith(".class") ? converterClassName.substring(0, converterClassName.indexOf(".class")) : converterClassName;
                this.register(converterClassName);
            }
        }
        catch (IOException cause) {
            throw RuntimeExceptionsFactory.newRuntimeException(cause, "Failed to access JAR file [%s]", jarFilePathname);
        }
    }

    private void registerConvertersFromFileSystem(String converterClassResourceName, URL converterClassResourceLocation) {
        try {
            File convertersPackagePath = new File(converterClassResourceLocation.toURI()).getParentFile();
            Assert.isTrue(convertersPackagePath.isDirectory(), "Directory for Converters package [%s] does not exist", convertersPackagePath.getAbsolutePath());
            for (File classFile : convertersPackagePath.listFiles(new FileExtensionFilter(".class"))) {
                String converterClassName = CONVERTERS_PACKAGE.getName().concat(".").concat(FileUtils.getName(classFile));
                this.register(converterClassName);
            }
        }
        catch (URISyntaxException cause) {
            throw RuntimeExceptionsFactory.newRuntimeException(cause, "Failed to create File reference to directory [%s] of Converters package", converterClassResourceName.substring(0, converterClassResourceName.lastIndexOf(File.separator) + 1));
        }
    }

    @Override
    private void register(String converterClassName) {
        Class converterClass = ObjectUtils.loadClass(converterClassName);
        if (ObjectUtils.assignableTo(converterClass, Converter.class)) {
            try {
                Converter converter = (Converter)converterClass.newInstance();
                this.register(converter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initDefaultValues() {
        this.defaultValues.put(BigDecimal.class, new BigDecimal(0.0));
        this.defaultValues.put(BigInteger.class, new BigInteger("0"));
        this.defaultValues.put(Boolean.class, false);
        this.defaultValues.put(Byte.class, (byte)0);
        this.defaultValues.put(Calendar.class, CalendarValueSupplier.INSTANCE);
        this.defaultValues.put(Character.class, Character.valueOf('\u0000'));
        this.defaultValues.put(Double.class, 0.0);
        this.defaultValues.put(Enum.class, null);
        this.defaultValues.put(Float.class, Float.valueOf(0.0f));
        this.defaultValues.put(Integer.class, 0);
        this.defaultValues.put(Identifiable.class, null);
        this.defaultValues.put(Long.class, 0L);
        this.defaultValues.put(Short.class, (short)0);
        this.defaultValues.put(String.class, null);
    }

    public <T> T unsetDefaultValue(Class<?> type) {
        return (T)this.defaultValues.remove(type);
    }

    public <T> void setDefaultValue(Class<T> type, T defaultValue) {
        Assert.notNull(type, "Class type is required", new Object[0]);
        this.defaultValues.put(type, defaultValue);
    }

    public <T> void setDefaultValue(Class<T> type, Supplier<T> defaultValueSupplier) {
        Assert.notNull(type, "Class type is required", new Object[0]);
        this.defaultValues.put(type, defaultValueSupplier);
    }

    public <T> T getDefaultValue(Class<T> type) {
        Object value = this.defaultValues.get(type);
        if (value instanceof Supplier) {
            value = ((Supplier)value).get();
        }
        return type.cast(value);
    }

    public void setDefaultValuesEnabled(boolean defaultsEnabled) {
        this.defaultsEnabled = defaultsEnabled;
    }

    public boolean isDefaultValuesEnabled() {
        return this.defaultsEnabled;
    }

    @Override
    public <T> T convert(Object value, Class<T> toType) {
        return this.useDefault(value, toType) ? this.getDefaultValue(toType) : super.convert(value, toType);
    }

    protected boolean useDefault(Object value, Class<?> toType) {
        return value == null && this.isDefaultValuesEnabled() && this.defaultValues.containsKey(toType);
    }

    public static class CalendarValueSupplier
    implements Supplier<Calendar> {
        public static final CalendarValueSupplier INSTANCE = new CalendarValueSupplier();

        @Override
        public Calendar get() {
            return Calendar.getInstance();
        }
    }
}

