/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.support;

import java.beans.PropertyEditorSupport;
import org.cp.elements.data.conversion.ConversionException;
import org.cp.elements.data.conversion.Converter;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.RuntimeExceptionsFactory;

public class ConvertingPropertyEditorAdapter
extends PropertyEditorSupport {
    private final Converter<String, ?> converter;

    public static ConvertingPropertyEditorAdapter of(Converter<String, ?> converter) {
        return new ConvertingPropertyEditorAdapter(converter);
    }

    protected ConvertingPropertyEditorAdapter(Converter<String, ?> converter) {
        Assert.notNull(converter, "Converter is required", new Object[0]);
        this.converter = converter;
    }

    protected Converter<String, ?> getConverter() {
        return this.converter;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            this.setValue(this.getConverter().convert(text));
        }
        catch (ConversionException cause) {
            throw RuntimeExceptionsFactory.newIllegalArgumentException(cause, "Could not set text [%s] as value", text);
        }
    }
}

