/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.support;

import java.beans.PropertyEditor;
import org.cp.elements.data.conversion.AbstractConverter;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ElementsExceptionsFactory;

public class PropertyEditingConverterAdapter
extends AbstractConverter<String, Object> {
    private final PropertyEditor propertyEditor;

    public static PropertyEditingConverterAdapter of(PropertyEditor propertyEditor) {
        return new PropertyEditingConverterAdapter(propertyEditor);
    }

    protected PropertyEditingConverterAdapter(PropertyEditor propertyEditor) {
        Assert.notNull(propertyEditor, "PropertyEditor is required", new Object[0]);
        this.propertyEditor = propertyEditor;
    }

    protected PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    @Override
    public Object convert(String value) {
        try {
            this.getPropertyEditor().setAsText(value);
            return this.getPropertyEditor().getValue();
        }
        catch (IllegalArgumentException cause) {
            throw ElementsExceptionsFactory.newConversionException(cause, "Cannot convert [%s] to an Object type", value);
        }
    }
}

