/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.struct;

import java.util.Iterator;
import java.util.Optional;
import org.cp.elements.data.struct.BloomFilter;
import org.cp.elements.data.struct.SimpleBloomFilter;
import org.cp.elements.lang.Assert;
import org.cp.elements.util.ArrayUtils;
import org.cp.elements.util.stream.StreamUtils;

public class ScalableBloomFilter<T>
implements BloomFilter<T>,
Iterable<BloomFilter<T>> {
    protected static final float DEFAULT_ACCEPTABLE_FALSE_POSITIVE_RATE = 0.01f;
    protected static final int DEFAULT_SCALE = 64;
    protected static final int DEFAULT_NUMBER_OF_ELEMENTS_PER_FILTER = 10000000;
    private float acceptableFalsePositiveRate = 0.01f;
    private int approximateNumberOfElementsPerFilter = 10000000;
    private final BloomFilter<T>[] bloomFilters;

    public static <T> ScalableBloomFilter<T> ofOne() {
        return ScalableBloomFilter.of(1);
    }

    public static <T> ScalableBloomFilter<T> of(int scale) {
        return new ScalableBloomFilter<T>(scale);
    }

    public ScalableBloomFilter() {
        this(64);
    }

    public ScalableBloomFilter(int scale) {
        Assert.isTrue(scale > 0, "Scale [%d] must be greater than 0", scale);
        this.bloomFilters = new BloomFilter[scale];
    }

    public float getAcceptableFalsePositiveRate() {
        return this.acceptableFalsePositiveRate;
    }

    public int getApproximateNumberOfElementsPerFilter() {
        return this.approximateNumberOfElementsPerFilter;
    }

    BloomFilter<T>[] getBloomFilters() {
        return this.bloomFilters;
    }

    public int getScale() {
        return this.getBloomFilters().length;
    }

    @Override
    public synchronized boolean accept(T element) {
        return Optional.ofNullable(element).map(Object::hashCode).map(hashCode -> hashCode % this.getScale()).map(index -> this.getBloomFilters()[index]).map(bloomFilter -> bloomFilter.accept(element)).orElse(false);
    }

    @Override
    public synchronized void add(T element) {
        Optional.ofNullable(element).ifPresent(it -> {
            int hashCode = it.hashCode();
            int index = hashCode % this.getScale();
            BloomFilter<Object> bloomFilter = this.resolveBloomFilter(index);
            bloomFilter.add(it);
        });
    }

    @Override
    public Iterator<BloomFilter<T>> iterator() {
        return ArrayUtils.asIterator(this.getBloomFilters());
    }

    @Override
    public int size() {
        return StreamUtils.stream(this).mapToInt(BloomFilter::size).sum();
    }

    protected BloomFilter<T> newBloomFilter(int approximateNumberOfElements, float acceptableFalsePositiveRate) {
        return SimpleBloomFilter.of(approximateNumberOfElements, acceptableFalsePositiveRate);
    }

    protected BloomFilter<T> resolveBloomFilter(int index) {
        return Optional.ofNullable(this.getBloomFilters()[index]).orElseGet(() -> {
            BloomFilter<T> bloomFilter = this.newBloomFilter(this.getApproximateNumberOfElementsPerFilter(), this.getAcceptableFalsePositiveRate());
            this.getBloomFilters()[index] = bloomFilter;
            return bloomFilter;
        });
    }

    public ScalableBloomFilter<T> with(float acceptableFalsePositiveRate) {
        Assert.isTrue(acceptableFalsePositiveRate > 0.0f && acceptableFalsePositiveRate < 1.0f, "The acceptable false positive rate [%s] must be greater than 0.0 and less than 1.0", String.valueOf(acceptableFalsePositiveRate));
        this.acceptableFalsePositiveRate = acceptableFalsePositiveRate;
        return this;
    }

    public ScalableBloomFilter<T> with(int approximateNumberOfElementsPerFilter) {
        Assert.isTrue(approximateNumberOfElementsPerFilter > 0, "The approximate number of elements [%d] per Bloom Filter must be greater than 0", approximateNumberOfElementsPerFilter);
        this.approximateNumberOfElementsPerFilter = approximateNumberOfElementsPerFilter;
        return this;
    }
}

