/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.struct;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.cp.elements.data.struct.BloomFilter;
import org.cp.elements.lang.Assert;

public class SimpleBloomFilter<T>
implements BloomFilter<T> {
    protected static final float DEFAULT_ACCEPTABLE_FALSE_POSITIVE_RATE = 0.01f;
    protected static final int DEFAULT_BIT_ARRAY_LENGTH = 16384;
    protected static final int DEFAULT_NUMBER_OF_BITS = 524288;
    protected static final int DEFAULT_NUMBER_OF_HASH_FUNCTIONS = 11;
    protected static final int[] BIT_MASKS = new int[32];
    private float falsePositiveRate;
    private final int hashFunctionCount;
    private final int[] bitArray;
    private final Random random = new Random();

    public static <T> SimpleBloomFilter<T> ofOne() {
        return SimpleBloomFilter.of(1, 0.01f);
    }

    public static <T> SimpleBloomFilter<T> of(int approximateNumberOfElements) {
        return SimpleBloomFilter.of(approximateNumberOfElements, 0.01f);
    }

    public static <T> SimpleBloomFilter<T> of(int approximateNumberOfElements, float acceptableFalsePositiveRate) {
        Assert.isTrue(approximateNumberOfElements > 0, "The approximate number of elements [%d] to add to the filter must be greater than 0", approximateNumberOfElements);
        Assert.isTrue(acceptableFalsePositiveRate > 0.0f && acceptableFalsePositiveRate < 1.0f, "The acceptable false positive rate [%s] must be greater than 0.0 and less than 1.0", String.valueOf(acceptableFalsePositiveRate));
        int requiredNumberOfBits = SimpleBloomFilter.computeRequiredNumberOfBits(approximateNumberOfElements, acceptableFalsePositiveRate);
        int optimalNumberOfHashFunctions = SimpleBloomFilter.computeOptimalNumberOfHashFunctions(approximateNumberOfElements, requiredNumberOfBits);
        SimpleBloomFilter<T> bloomFilter = new SimpleBloomFilter<T>(requiredNumberOfBits, optimalNumberOfHashFunctions);
        bloomFilter.falsePositiveRate = acceptableFalsePositiveRate;
        return bloomFilter;
    }

    protected static int computeRequiredNumberOfBits(double approximateNumberOfElements, double acceptableFalsePositiveRate) {
        double numberOfBits = Math.abs(approximateNumberOfElements * Math.log(acceptableFalsePositiveRate) / Math.pow(Math.log(2.0), 2.0));
        return Double.valueOf(Math.ceil(numberOfBits)).intValue();
    }

    protected static int computeOptimalNumberOfHashFunctions(double approximateNumberOfElements, double requiredNumberOfBits) {
        double numberOfHashFunctions = requiredNumberOfBits / approximateNumberOfElements * Math.log(2.0);
        return Double.valueOf(Math.ceil(numberOfHashFunctions)).intValue();
    }

    public SimpleBloomFilter() {
        this(524288, 11);
    }

    public SimpleBloomFilter(int numberOfBits, int numberOfHashFunctions) {
        Assert.isTrue(numberOfBits > 0, "Number of bits [%d] must be greater than 0", numberOfBits);
        Assert.isTrue(numberOfHashFunctions > 0, "Number of hash functions [%d] must be greater than 0", numberOfHashFunctions);
        this.bitArray = new int[this.getBitArrayLength(numberOfBits)];
        this.hashFunctionCount = numberOfHashFunctions;
        Arrays.fill(this.bitArray, 0);
    }

    int[] getBitArray() {
        return this.bitArray;
    }

    protected int getBitArrayLength(int requiredNumberOfBits) {
        int remainder = requiredNumberOfBits % 32;
        int additionalNumberOfBits = remainder != 0 ? 32 - remainder : 0;
        return (requiredNumberOfBits + additionalNumberOfBits) / 32;
    }

    public float getFalsePositiveRate() {
        return this.falsePositiveRate;
    }

    protected int getFilterSize() {
        return this.getBitArray().length * 32;
    }

    protected int getHashFunctionCount(T element) {
        return this.hashFunctionCount;
    }

    @Override
    public synchronized boolean accept(T element) {
        boolean accepted;
        boolean bl = accepted = element != null;
        if (accepted) {
            int filterSize = this.getFilterSize();
            int hashFunctionCount = this.getHashFunctionCount(element);
            this.random.setSeed(element.hashCode());
            for (int count = 0; accepted && count < hashFunctionCount; ++count) {
                int bitIndex = this.random.nextInt(filterSize);
                accepted = (this.bitArray[bitIndex / 32] & BIT_MASKS[bitIndex % 32]) != 0;
            }
        }
        return accepted;
    }

    @Override
    public synchronized void add(T element) {
        Assert.notNull(element, "Element cannot be null", new Object[0]);
        int filterSize = this.getFilterSize();
        int hashFunctionCount = this.getHashFunctionCount(element);
        this.random.setSeed(element.hashCode());
        for (int count = 0; count < hashFunctionCount; ++count) {
            int bitIndex = this.random.nextInt(filterSize);
            int n = bitIndex / 32;
            this.bitArray[n] = this.bitArray[n] | BIT_MASKS[bitIndex % 32];
        }
    }

    @Override
    public int size() {
        double filterSize = this.getFilterSize();
        double numberOfBitsSetToOne = this.countNumberOfBitsSetToOne();
        double numberOfHashFunctions = this.getHashFunctionCount(null);
        double estimatedSize = filterSize / numberOfHashFunctions * Math.log(1.0 - numberOfBitsSetToOne / filterSize);
        return Double.valueOf(Math.abs(Math.round(estimatedSize))).intValue();
    }

    private int countNumberOfBitsSetToOne() {
        AtomicInteger numberOfBitsSetToOne = new AtomicInteger(0);
        Arrays.stream(this.getBitArray()).forEach(bucket -> {
            for (int bitMask : BIT_MASKS) {
                if ((bucket & bitMask) == 0) continue;
                numberOfBitsSetToOne.incrementAndGet();
            }
        });
        return numberOfBitsSetToOne.get();
    }

    static {
        SimpleBloomFilter.BIT_MASKS[0] = 1;
        SimpleBloomFilter.BIT_MASKS[1] = 2;
        SimpleBloomFilter.BIT_MASKS[2] = 4;
        SimpleBloomFilter.BIT_MASKS[3] = 8;
        SimpleBloomFilter.BIT_MASKS[4] = 16;
        SimpleBloomFilter.BIT_MASKS[5] = 32;
        SimpleBloomFilter.BIT_MASKS[6] = 64;
        SimpleBloomFilter.BIT_MASKS[7] = 128;
        SimpleBloomFilter.BIT_MASKS[8] = 256;
        SimpleBloomFilter.BIT_MASKS[9] = 512;
        SimpleBloomFilter.BIT_MASKS[10] = 1024;
        SimpleBloomFilter.BIT_MASKS[11] = 2048;
        SimpleBloomFilter.BIT_MASKS[12] = 4096;
        SimpleBloomFilter.BIT_MASKS[13] = 8192;
        SimpleBloomFilter.BIT_MASKS[14] = 16384;
        SimpleBloomFilter.BIT_MASKS[15] = 32768;
        SimpleBloomFilter.BIT_MASKS[16] = 65536;
        SimpleBloomFilter.BIT_MASKS[17] = 131072;
        SimpleBloomFilter.BIT_MASKS[18] = 262144;
        SimpleBloomFilter.BIT_MASKS[19] = 524288;
        SimpleBloomFilter.BIT_MASKS[20] = 0x100000;
        SimpleBloomFilter.BIT_MASKS[21] = 0x200000;
        SimpleBloomFilter.BIT_MASKS[22] = 0x400000;
        SimpleBloomFilter.BIT_MASKS[23] = 0x800000;
        SimpleBloomFilter.BIT_MASKS[24] = 0x1000000;
        SimpleBloomFilter.BIT_MASKS[25] = 0x2000000;
        SimpleBloomFilter.BIT_MASKS[26] = 0x4000000;
        SimpleBloomFilter.BIT_MASKS[27] = 0x8000000;
        SimpleBloomFilter.BIT_MASKS[28] = 0x10000000;
        SimpleBloomFilter.BIT_MASKS[29] = 0x20000000;
        SimpleBloomFilter.BIT_MASKS[30] = 0x40000000;
        SimpleBloomFilter.BIT_MASKS[31] = Integer.MIN_VALUE;
    }
}

