/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.struct;

import java.util.Map;
import java.util.Optional;
import org.cp.elements.data.struct.KeyValue;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ObjectUtils;

public class SimpleKeyValue<KEY, VALUE>
implements KeyValue<KEY, VALUE> {
    private final KEY key;
    private final VALUE value;

    public static <KEY, VALUE> SimpleKeyValue<KEY, VALUE> from(Map.Entry<KEY, VALUE> mapEntry) {
        Assert.notNull(mapEntry, "Map.Entry is required", new Object[0]);
        return SimpleKeyValue.newKeyValue(mapEntry.getKey(), mapEntry.getValue());
    }

    public static <KEY, VALUE> SimpleKeyValue<KEY, VALUE> newKeyValue(KEY key) {
        return new SimpleKeyValue<KEY, VALUE>(key);
    }

    public static <KEY, VALUE> SimpleKeyValue<KEY, VALUE> newKeyValue(KEY key, VALUE value) {
        return new SimpleKeyValue<KEY, VALUE>(key, value);
    }

    public SimpleKeyValue(KEY key) {
        this(key, null);
    }

    public SimpleKeyValue(KEY key, VALUE value) {
        Assert.notNull(key, "Key is required", new Object[0]);
        this.key = key;
        this.value = value;
    }

    @Override
    public boolean isSet() {
        return this.getValue(null) != null;
    }

    @Override
    public KEY getKey() {
        return this.key;
    }

    @Override
    public Optional<VALUE> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public VALUE getValue(VALUE defaultValue) {
        return this.getValue().orElse(defaultValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleKeyValue)) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        SimpleKeyValue that = (SimpleKeyValue)obj;
        return this.getKey().equals(that.getKey()) && ObjectUtils.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getKey());
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getValue());
        return hashValue;
    }

    public String toString() {
        return String.format("%1$s = %2$s", this.getKey(), this.getValue(null));
    }
}

