/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.struct;

import java.util.Optional;
import java.util.ServiceLoader;
import org.cp.elements.data.conversion.ConversionService;
import org.cp.elements.data.struct.SimpleKeyValue;
import org.cp.elements.lang.StringUtils;

public abstract class StringBasedKeyValue
extends SimpleKeyValue<String, String> {
    private final ConversionService conversionService = ServiceLoader.load(ConversionService.class).iterator().next();

    protected StringBasedKeyValue(String key) {
        super(key);
    }

    protected StringBasedKeyValue(String key, String value) {
        super(key, value);
    }

    protected ConversionService getConversionService() {
        return this.conversionService;
    }

    public <T> Optional<T> getValueAs(Class<T> type) {
        return this.getValue().filter(StringUtils::hasText).map(value -> this.getConversionService().convert(value, type));
    }

    public <T> T getValueAs(Class<T> type, T defaultValue) {
        return (T)this.getValue().filter(StringUtils::hasText).map(value -> this.getConversionService().convert(value, type)).orElse(defaultValue);
    }
}

