/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.enums;

public enum Country {
    UNITED_STATES_OF_AMERICA("USA", "United States of America");

    private final String abbreviation;
    private final String name;

    private Country(String abbreviation, String name) {
        this.abbreviation = abbreviation;
        this.name = name;
    }

    public static Country valueOfAbbreviation(String abbreviation) {
        for (Country country : Country.values()) {
            if (!country.getAbbreviation().equalsIgnoreCase(abbreviation)) continue;
            return country;
        }
        return null;
    }

    public static Country valueOfName(String name) {
        for (Country country : Country.values()) {
            if (!country.getName().equalsIgnoreCase(name)) continue;
            return country;
        }
        return null;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

