/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.enums;

public enum Gender {
    FEMALE("F", "Female"),
    MALE("M", "Male");

    private final String abbreviation;
    private final String name;

    private Gender(String abbreviation, String name) {
        this.abbreviation = abbreviation;
        this.name = name;
    }

    public static Gender valueOfAbbreviation(String abbreviation) {
        for (Gender gender : Gender.values()) {
            if (!gender.getAbbreviation().equalsIgnoreCase(abbreviation)) continue;
            return gender;
        }
        return null;
    }

    public static Gender valueOfName(String name) {
        for (Gender gender : Gender.values()) {
            if (!gender.getName().equalsIgnoreCase(name)) continue;
            return gender;
        }
        return null;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

