/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.enums;

public enum Order {
    ASCENDING("ASC", "Ascending"),
    DESCENDING("DESC", "Descending");

    private final String abbreviation;
    private final String name;

    private Order(String abbreviation, String name) {
        this.abbreviation = abbreviation;
        this.name = name;
    }

    public static Order valueOfAbbreviation(String abbreviation) {
        for (Order order : Order.values()) {
            if (!order.getAbbreviation().equalsIgnoreCase(abbreviation)) continue;
            return order;
        }
        return null;
    }

    public static Order valueOfName(String name) {
        for (Order order : Order.values()) {
            if (!order.getName().equalsIgnoreCase(name)) continue;
            return order;
        }
        return null;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

