/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.enums;

public enum Race {
    AFRICAN_AMERICAN("Black", "African American"),
    ALASKAN_NATIVE("Eskimo", "Alaskan Native"),
    ASIAN("Asian", "Asian"),
    EUROPEAN("European", "European"),
    HISPANIC("Hispanic", "Hispanic"),
    INDIAN("Indi", "Indian"),
    NATIVE_AMERICAN("Indian", "Native American"),
    WHITE("White", "White");

    private final String abbreviation;
    private final String name;

    private Race(String abbreviation, String name) {
        this.abbreviation = abbreviation;
        this.name = name;
    }

    public static Race valueOfAbbreviation(String abbreviation) {
        for (Race race : Race.values()) {
            if (!race.getAbbreviation().equalsIgnoreCase(abbreviation)) continue;
            return race;
        }
        return null;
    }

    public static Race valueOfName(String name) {
        for (Race race : Race.values()) {
            if (!race.getName().equalsIgnoreCase(name)) continue;
            return race;
        }
        return null;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

