/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.enums;

public enum TimeUnit {
    NANOSECOND("ns", "Nanosecond", "1 billionth of a second"),
    MICROSECOND("us", "Microsecond", "1 millionth of a second"),
    MILLISECOND("ms", "Millisecond", "1 thousandth of a second"),
    SECOND("s", "Second", "1 second"),
    MINUTE("mi", "Minute", "60 seconds"),
    HOUR("hr", "Hour", "60 minutes"),
    DAY("day", "Day", "24 hours"),
    WEEK("wk", "Week", "7 days"),
    MONTH("mon", "Month", "28-31 days"),
    YEAR("yr", "Year", "12 months, 365 days"),
    DECADE("dec", "Decade", "10 years"),
    SCORE("Score", "Score", "20 years"),
    CENTURY("cent", "Century", "100 years"),
    MILLENIA("Millenia", "Millenia", "1000 years");

    private final String abbreviation;
    private final String description;
    private final String name;

    private TimeUnit(String abbreviation, String name, String description) {
        this.abbreviation = abbreviation;
        this.name = name;
        this.description = description;
    }

    public static TimeUnit valueOfAbbreviation(String abbreviation) {
        for (TimeUnit unit : TimeUnit.values()) {
            if (!unit.getAbbreviation().equalsIgnoreCase(abbreviation)) continue;
            return unit;
        }
        return null;
    }

    public static TimeUnit valueOfName(String name) {
        for (TimeUnit unit : TimeUnit.values()) {
            if (!unit.getName().equalsIgnoreCase(name)) continue;
            return unit;
        }
        return null;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

