/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.enums;

import org.cp.elements.util.CollectionExtensions;

public enum Weekday {
    SUNDAY("Sun", "Sunday", 1, 1),
    MONDAY("Mon", "Monday", 2, 2),
    TUESDAY("Tue", "Tuesday", 3, 3),
    WEDNESDAY("Wed", "Wednesday", 4, 4),
    THURSDAY("Thu", "Thursday", 5, 5),
    FRIDAY("Fri", "Friday", 6, 6),
    SATURDAY("Sat", "Saturday", 7, 7);

    private final int calendarConstant;
    private final int position;
    private final String abbreviation;
    private final String name;

    private Weekday(String abbreviation, String name, int position, int calendarConstant) {
        this.abbreviation = abbreviation;
        this.name = name;
        this.position = position;
        this.calendarConstant = calendarConstant;
    }

    public static Weekday valueOfAbbreviation(String abbreviation) {
        for (Weekday day : Weekday.values()) {
            if (!day.getAbbreviation().equalsIgnoreCase(abbreviation)) continue;
            return day;
        }
        return null;
    }

    public static Weekday valueOfCalendarConstant(int calendarConstant) {
        for (Weekday day : Weekday.values()) {
            if (day.getCalendarConstant() != calendarConstant) continue;
            return day;
        }
        return null;
    }

    public static Weekday valueOfName(String name) {
        for (Weekday day : Weekday.values()) {
            if (!day.getName().equalsIgnoreCase(name)) continue;
            return day;
        }
        return null;
    }

    public static Weekday valueOfPosition(int position) {
        for (Weekday day : Weekday.values()) {
            if (day.getPosition() != position) continue;
            return day;
        }
        return null;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public int getCalendarConstant() {
        return this.calendarConstant;
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isWeekday() {
        return !this.isWeekend();
    }

    public boolean isWeekend() {
        return CollectionExtensions.from(SUNDAY, SATURDAY).toSet().contains((Object)this);
    }

    public String toString() {
        return this.name;
    }
}

