/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.io;

import java.io.File;
import java.io.FileFilter;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.Composite;
import org.cp.elements.lang.Filter;
import org.cp.elements.lang.LogicalOperator;
import org.cp.elements.util.ArrayUtils;

public class ComposableFileFilter
implements Composite<FileFilter>,
FileFilter,
Filter<File> {
    protected static final ComposableFileFilter INSTANCE = new ComposableFileFilter();
    private final FileFilter leftOperand;
    private final FileFilter rightOperand;
    private final LogicalOperator operator;

    public static ComposableFileFilter builder() {
        return INSTANCE;
    }

    private ComposableFileFilter() {
        this.leftOperand = file -> false;
        this.rightOperand = file -> false;
        this.operator = LogicalOperator.AND;
    }

    private ComposableFileFilter(LogicalOperator operator, FileFilter leftOperand, FileFilter rightOperand) {
        Assert.notNull(operator, "The logical operator must be specified", new Object[0]);
        Assert.notNull(leftOperand, "The left FileFilter operand cannot be null", new Object[0]);
        Assert.notNull(rightOperand, "The right FileFilter operand cannot be null", new Object[0]);
        this.operator = operator;
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
    }

    protected static FileFilter compose(LogicalOperator operator, FileFilter leftOperand, FileFilter rightOperand) {
        return leftOperand == null ? rightOperand : (rightOperand == null ? leftOperand : new ComposableFileFilter(operator, leftOperand, rightOperand));
    }

    public static FileFilter and(FileFilter ... fileFilters) {
        FileFilter composedFileFilter = null;
        for (FileFilter fileFilter : ArrayUtils.nullSafeArray(fileFilters, FileFilter.class)) {
            composedFileFilter = ComposableFileFilter.compose(LogicalOperator.AND, composedFileFilter, fileFilter);
        }
        return composedFileFilter;
    }

    public static FileFilter or(FileFilter ... fileFilters) {
        FileFilter composedFileFilter = null;
        for (FileFilter fileFilter : ArrayUtils.nullSafeArray(fileFilters, FileFilter.class)) {
            composedFileFilter = ComposableFileFilter.compose(LogicalOperator.OR, composedFileFilter, fileFilter);
        }
        return composedFileFilter;
    }

    public static FileFilter xor(FileFilter leftOperand, FileFilter rightOperand) {
        return ComposableFileFilter.compose(LogicalOperator.XOR, leftOperand, rightOperand);
    }

    @Override
    public FileFilter compose(FileFilter one, FileFilter two) {
        return ComposableFileFilter.compose(LogicalOperator.AND, one, two);
    }

    protected FileFilter getLeftOperand() {
        return this.leftOperand;
    }

    protected LogicalOperator getOperator() {
        return this.operator;
    }

    protected FileFilter getRightOperand() {
        return this.rightOperand;
    }

    @Override
    public boolean accept(File file) {
        return this.getOperator().evaluate(() -> this.getLeftOperand().accept(file), () -> this.getRightOperand().accept(file));
    }
}

