/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.io;

import java.io.File;
import java.util.Comparator;
import org.cp.elements.io.FileUtils;

public abstract class FileComparatorFactory {
    public static Comparator<File> fileExtensionComparator() {
        return Comparator.comparing(FileUtils::getExtension);
    }

    public static Comparator<File> fileLastModifiedComparator() {
        return (fileOne, fileTwo) -> Long.valueOf(fileOne.lastModified()).compareTo(fileTwo.lastModified());
    }

    public static Comparator<File> fileNameComparator() {
        return Comparator.comparing(File::getName);
    }

    public static Comparator<File> filePathComparator() {
        return Comparator.comparing(File::getAbsolutePath);
    }

    public static Comparator<File> fileSizeComparator() {
        return (fileOne, fileTwo) -> Long.valueOf(fileOne.length()).compareTo(fileTwo.length());
    }
}

