/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.cp.elements.io.FileUtils;
import org.cp.elements.lang.Filter;
import org.cp.elements.lang.StringUtils;
import org.cp.elements.util.ArrayUtils;
import org.cp.elements.util.stream.StreamUtils;

public class FileExtensionFilter
implements FileFilter,
Filter<File>,
Iterable<String> {
    private final Set<String> fileExtensions;

    public FileExtensionFilter(String ... fileExtensions) {
        this(ArrayUtils.asIterable(fileExtensions));
    }

    public FileExtensionFilter(Iterable<String> fileExtensions) {
        this.fileExtensions = StreamUtils.stream(fileExtensions).filter(StringUtils::hasText).map(fileExtension -> (fileExtension.startsWith(".") ? fileExtension.substring(1) : fileExtension).toLowerCase().trim()).collect(Collectors.toSet());
    }

    public Set<String> getFileExtensions() {
        return Collections.unmodifiableSet(this.fileExtensions);
    }

    @Override
    public boolean accept(File file) {
        Set<String> fileExtensions = this.getFileExtensions();
        return fileExtensions.isEmpty() || fileExtensions.contains(FileUtils.getExtension(file).toLowerCase().trim());
    }

    @Override
    public Iterator<String> iterator() {
        return this.getFileExtensions().iterator();
    }
}

