/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.io;

import java.io.File;
import java.io.FileFilter;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import org.cp.elements.lang.Filter;
import org.cp.elements.lang.RelationalOperator;

public abstract class FileLastModifiedFilter
implements FileFilter,
Filter<File> {
    protected static FileLastModifiedFilter create(final RelationalOperator<Long> operator) {
        return new FileLastModifiedFilter(){

            @Override
            public boolean accept(File file) {
                return file != null && operator.evaluate(file.lastModified());
            }
        };
    }

    @Override
    public abstract boolean accept(File var1);

    public static FileLastModifiedFilter after(long lastModified) {
        return FileLastModifiedFilter.create(RelationalOperator.greaterThan(lastModified));
    }

    public static FileLastModifiedFilter after(Calendar dateTime) {
        return FileLastModifiedFilter.after(dateTime.getTimeInMillis());
    }

    public static FileLastModifiedFilter after(Date dateTime) {
        return FileLastModifiedFilter.after(dateTime.getTime());
    }

    public static FileLastModifiedFilter after(LocalDateTime dateTime) {
        return FileLastModifiedFilter.after(dateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static FileLastModifiedFilter before(long lastModified) {
        return FileLastModifiedFilter.create(RelationalOperator.lessThan(lastModified));
    }

    public static FileLastModifiedFilter before(Calendar dateTime) {
        return FileLastModifiedFilter.before(dateTime.getTimeInMillis());
    }

    public static FileLastModifiedFilter before(Date dateTime) {
        return FileLastModifiedFilter.before(dateTime.getTime());
    }

    public static FileLastModifiedFilter before(LocalDateTime dateTime) {
        return FileLastModifiedFilter.before(dateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static FileLastModifiedFilter during(long lastModifiedBegin, long lastModifiedEnd) {
        return FileLastModifiedFilter.create(RelationalOperator.greaterThanEqualToAndLessThanEqualTo(lastModifiedBegin, lastModifiedEnd));
    }

    public static FileLastModifiedFilter during(Calendar dateTimeBegin, Calendar dateTimeEnd) {
        return FileLastModifiedFilter.during(dateTimeBegin.getTimeInMillis(), dateTimeEnd.getTimeInMillis());
    }

    public static FileLastModifiedFilter during(Date dateTimeBegin, Date dateTimeEnd) {
        return FileLastModifiedFilter.during(dateTimeBegin.getTime(), dateTimeEnd.getTime());
    }

    public static FileLastModifiedFilter during(LocalDateTime dateTimeBegin, LocalDateTime dateTimeEnd) {
        return FileLastModifiedFilter.during(dateTimeBegin.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli(), dateTimeEnd.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static FileLastModifiedFilter on(long lastModified) {
        return FileLastModifiedFilter.create(RelationalOperator.equalTo(lastModified));
    }

    public static FileLastModifiedFilter on(Calendar dateTime) {
        return FileLastModifiedFilter.on(dateTime.getTimeInMillis());
    }

    public static FileLastModifiedFilter on(Date dateTime) {
        return FileLastModifiedFilter.on(dateTime.getTime());
    }

    public static FileLastModifiedFilter on(LocalDateTime dateTime) {
        return FileLastModifiedFilter.on(dateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static FileLastModifiedFilter outside(long onBefore, long onAfter) {
        return FileLastModifiedFilter.create(RelationalOperator.lessThanEqualToOrGreaterThanEqualTo(onBefore, onAfter));
    }

    public static FileLastModifiedFilter outside(Calendar onBefore, Calendar onAfter) {
        return FileLastModifiedFilter.outside(onBefore.getTimeInMillis(), onAfter.getTimeInMillis());
    }

    public static FileLastModifiedFilter outside(Date onBefore, Date onAfter) {
        return FileLastModifiedFilter.outside(onBefore.getTime(), onAfter.getTime());
    }

    public static FileLastModifiedFilter outside(LocalDateTime onBefore, LocalDateTime onAfter) {
        return FileLastModifiedFilter.outside(onBefore.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli(), onAfter.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }
}

