/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.io;

import java.io.File;
import java.io.FileFilter;
import org.cp.elements.lang.Filter;
import org.cp.elements.lang.RelationalOperator;

public abstract class FileSizeFilter
implements FileFilter,
Filter<File> {
    protected static FileSizeFilter create(final RelationalOperator<Long> operator) {
        return new FileSizeFilter(){

            @Override
            public boolean accept(File file) {
                return file != null && operator.evaluate(file.length());
            }
        };
    }

    @Override
    public abstract boolean accept(File var1);

    public static FileSizeFilter between(long minSize, long maxSize) {
        return FileSizeFilter.create(RelationalOperator.greaterThanEqualToAndLessThanEqualTo(minSize, maxSize));
    }

    public static FileSizeFilter equalTo(long size) {
        return FileSizeFilter.create(RelationalOperator.equalTo(size));
    }

    public static FileSizeFilter greaterThan(long size) {
        return FileSizeFilter.create(RelationalOperator.greaterThan(size));
    }

    public static FileSizeFilter lessThan(long size) {
        return FileSizeFilter.create(RelationalOperator.lessThan(size));
    }

    public static FileSizeFilter outside(long lessorSize, long greaterSize) {
        return FileSizeFilter.create(RelationalOperator.lessThanEqualToOrGreaterThanEqualTo(lessorSize, greaterSize));
    }
}

