/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.io;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.cp.elements.io.ComposableFileFilter;
import org.cp.elements.io.FileUtils;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.StringUtils;
import org.cp.elements.lang.SystemUtils;
import org.cp.elements.util.ArrayUtils;

public abstract class FileSystemUtils
extends FileUtils {
    public static final File JAVA_HOME = new File(SystemUtils.JAVA_HOME);
    public static final File JAVA_EXE = new File(new File(JAVA_HOME, "bin"), "java");
    public static final File TEMPORARY_DIRECTORY = new File(SystemUtils.TEMPORARY_DIRECTORY);
    public static final File USER_HOME_DIRECTORY = new File(SystemUtils.USER_HOME);
    public static final File WORKING_DIRECTORY = new File(SystemUtils.USER_DIRECTORY);
    public static final File[] NO_FILES = new File[0];
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String WINDOWS_FILE_SEPARATOR = "\\";
    public static final String WINDOWS_FILE_SEPARATOR_PATTERN = "\\+";
    public static final String UNIX_FILE_SEPARATOR = "/";
    public static final String UNIX_FILE_SEPARATOR_PATTERN = "/+";

    public static String appendToPath(String basePath, String ... pathElements) {
        Assert.notNull(basePath, "basePath cannot be null", new Object[0]);
        String fileSeparator = SystemUtils.isWindows() ? WINDOWS_FILE_SEPARATOR : File.separator;
        for (String pathElement : ArrayUtils.nullSafeArray(pathElements, String.class)) {
            if (!StringUtils.hasText(pathElement)) continue;
            basePath = String.format("%1$s%2$s%3$s", basePath.trim(), fileSeparator, pathElement.trim());
        }
        String fileSeparatorPattern = SystemUtils.isWindows() ? WINDOWS_FILE_SEPARATOR_PATTERN : UNIX_FILE_SEPARATOR_PATTERN;
        return basePath.trim().replaceAll(fileSeparatorPattern, fileSeparator);
    }

    public static String createPath(String ... pathElements) {
        String fileSeparator = SystemUtils.isWindows() ? WINDOWS_FILE_SEPARATOR : File.separator;
        StringBuilder buffer = new StringBuilder(fileSeparator);
        for (String pathElement : ArrayUtils.nullSafeArray(pathElements, String.class)) {
            if (!StringUtils.hasText(pathElement)) continue;
            buffer.append(fileSeparator).append(pathElement.trim());
        }
        String fileSeparatorPattern = SystemUtils.isWindows() ? WINDOWS_FILE_SEPARATOR_PATTERN : UNIX_FILE_SEPARATOR_PATTERN;
        return buffer.toString().replaceAll(fileSeparatorPattern, fileSeparator);
    }

    public static int count(File path) {
        return FileSystemUtils.count(path, FileUtils::isExisting);
    }

    public static int count(File path, FileFilter fileFilter) {
        int count = 0;
        for (File file : FileSystemUtils.safeListFiles(path, fileFilter)) {
            count += FileSystemUtils.isDirectory(file) ? FileSystemUtils.count(file, fileFilter) : 1;
        }
        return ComposableFileFilter.and(FileUtils::isFile, fileFilter).accept(path) ? 1 : count;
    }

    public static boolean deleteRecursive(File path) {
        return FileSystemUtils.deleteRecursive(path, FileUtils::isExisting);
    }

    public static boolean deleteRecursive(File path, FileFilter fileFilter) {
        boolean success = true;
        for (File file : FileSystemUtils.safeListFiles(path, fileFilter)) {
            success &= FileSystemUtils.isDirectory(file) ? FileSystemUtils.deleteRecursive(file, fileFilter) : FileSystemUtils.delete(file);
        }
        return success && fileFilter.accept(path) && FileSystemUtils.delete(path);
    }

    public static boolean isEmptyDirectory(File directory) {
        return FileSystemUtils.isDirectory(directory) && directory.listFiles().length == 0;
    }

    public static boolean isRelativeToWorkingDirectory(File path) {
        return path != null && FileSystemUtils.tryGetCanonicalPathElseGetAbsolutePath(path).startsWith(FileSystemUtils.tryGetCanonicalPathElseGetAbsolutePath(WORKING_DIRECTORY));
    }

    public static File[] listFiles(File directory) {
        return FileSystemUtils.listFiles(directory, FileUtils::isExisting);
    }

    public static File[] listFiles(File directory, FileFilter fileFilter) {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : FileSystemUtils.safeListFiles(directory, fileFilter)) {
            files.addAll(FileSystemUtils.isDirectory(file) ? Arrays.asList(FileSystemUtils.listFiles(file, fileFilter)) : Collections.singletonList(file));
        }
        return files.isEmpty() ? NO_FILES : files.toArray(new File[files.size()]);
    }

    static File[] safeListFiles(File path) {
        return FileSystemUtils.safeListFiles(path, FileUtils::isExisting);
    }

    static File[] safeListFiles(File path, FileFilter fileFilter) {
        return FileSystemUtils.isDirectory(path) ? path.listFiles(fileFilter) : NO_FILES;
    }

    public static long size(File path) {
        return FileSystemUtils.size(path, FileUtils::isExisting);
    }

    public static long size(File path, FileFilter fileFilter) {
        long size = 0L;
        for (File file : FileSystemUtils.safeListFiles(path, fileFilter)) {
            size += FileSystemUtils.isDirectory(file) ? FileSystemUtils.size(file, fileFilter) : file.length();
        }
        return ComposableFileFilter.and(FileUtils::isFile, fileFilter).accept(path) ? path.length() : size;
    }
}

