/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import org.cp.elements.io.IOUtils;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.StringUtils;

public abstract class FileUtils
extends IOUtils {
    public static File assertExists(File path) throws FileNotFoundException {
        if (FileUtils.isExisting(path)) {
            return path;
        }
        throw new FileNotFoundException(String.format("[%1$s] was not found", path));
    }

    public static boolean createDirectory(File path) {
        return path != null && !path.isFile() && (path.isDirectory() || path.mkdirs());
    }

    public static boolean createFile(File path) {
        try {
            return path != null && !path.isDirectory() && (path.isFile() || path.createNewFile());
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public static boolean delete(File path) {
        return FileUtils.isExisting(path) && path.delete();
    }

    public static String getExtension(File file) {
        Assert.notNull(file, "File cannot be null", new Object[0]);
        String filename = file.getName();
        int dotIndex = filename.indexOf(".");
        return dotIndex != -1 ? filename.substring(dotIndex + 1) : "";
    }

    public static String getLocation(File file) {
        Assert.notNull(file, "File cannot be null", new Object[0]);
        File parent = file.getParentFile();
        Assert.notNull(parent, new IllegalArgumentException(String.format("Unable to determine the location of file [%1$s]", file)));
        return FileUtils.tryGetCanonicalPathElseGetAbsolutePath(parent);
    }

    public static String getName(File file) {
        Assert.notNull(file, "File cannot be null", new Object[0]);
        String filename = file.getName();
        int dotIndex = filename.indexOf(".");
        return dotIndex != -1 ? filename.substring(0, dotIndex) : filename;
    }

    public static boolean isDirectory(File path) {
        return path != null && path.isDirectory();
    }

    public static boolean isEmpty(File path) {
        return FileUtils.size(path) == 0L;
    }

    public static boolean isExisting(File path) {
        return path != null && path.exists();
    }

    public static boolean isFile(File path) {
        return path != null && path.isFile();
    }

    public static File newFile(String pathname) {
        return new File(pathname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file) throws IOException {
        Assert.isTrue(FileUtils.isFile(file), "[%1$s] must be a valid file", file);
        Assert.state(file.canRead(), "[%1$s] is unreadable", FileUtils.tryGetCanonicalPathElseGetAbsolutePath(file));
        BufferedReader fileReader = new BufferedReader(new FileReader(file));
        StringBuilder buffer = new StringBuilder();
        try {
            String line = fileReader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append(StringUtils.LINE_SEPARATOR);
                line = fileReader.readLine();
            }
            String string = buffer.toString().trim();
            return string;
        }
        finally {
            FileUtils.close(fileReader);
        }
    }

    public static long size(File path) {
        return FileUtils.isFile(path) ? path.length() : 0L;
    }

    public static File tryGetCanonicalFileElseGetAbsoluteFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ignore) {
            return file.getAbsoluteFile();
        }
    }

    public static String tryGetCanonicalPathElseGetAbsolutePath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ignore) {
            return file.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File write(InputStream in, File file) throws IOException {
        File file2;
        Assert.notNull(in, "InputStream cannot be null", new Object[0]);
        Assert.notNull(file, "File cannot be null", new Object[0]);
        Assert.state(!FileUtils.isExisting(file) || file.canWrite(), "[%1$s] is not writable", FileUtils.tryGetCanonicalPathElseGetAbsolutePath(file));
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            FileUtils.copy(in, out);
            file2 = file;
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(out);
        return file2;
    }
}

