/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.Optional;
import org.cp.elements.lang.Assert;

public abstract class IOUtils {
    protected static final int DEFAULT_BUFFER_SIZE = 32768;

    public static boolean close(Closeable obj) {
        if (obj != null) {
            try {
                obj.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[32768];
        int length = in.read(buffer);
        while (length > 0) {
            out.write(buffer, 0, length);
            out.flush();
            length = in.read(buffer);
        }
    }

    public static boolean doSafeIo(IoExceptionThrowingOperation operation) {
        try {
            operation.doIo();
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public static <T> T deserialize(byte[] serializedObjectBytes) throws ClassNotFoundException, IOException {
        Object object;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(serializedObjectBytes));
            object = in.readObject();
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deserialize(byte[] serializedObjectBytes, ClassLoader classLoader) throws ClassNotFoundException, IOException {
        Object object;
        ClassLoaderObjectInputStream in = null;
        try {
            in = new ClassLoaderObjectInputStream(new ByteArrayInputStream(serializedObjectBytes), classLoader);
            object = in.readObject();
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Object obj) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream objOut = null;
        try {
            objOut = new ObjectOutputStream(out);
            objOut.writeObject(obj);
            objOut.flush();
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.close(objOut);
            throw throwable;
        }
        IOUtils.close(objOut);
        return byArray;
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        int bytesRead;
        Assert.notNull(in, "The InputStream to read bytes from cannot be null", new Object[0]);
        ByteArrayOutputStream out = new ByteArrayOutputStream(in.available());
        byte[] buffer = new byte[32768];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            out.flush();
        }
        return out.toByteArray();
    }

    @FunctionalInterface
    public static interface IoExceptionThrowingOperation {
        public void doIo() throws IOException;
    }

    protected static class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        public ClassLoaderObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = Optional.ofNullable(classLoader).orElseGet(() -> Thread.currentThread().getContextClassLoader());
        }

        protected ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass descriptor) throws ClassNotFoundException, IOException {
            return Class.forName(descriptor.getName(), false, this.getClassLoader());
        }
    }
}

