/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.io;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;
import org.cp.elements.io.FileUtils;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.Filter;

public class RegexFileFilter
implements FileFilter,
Filter<File> {
    private final Pattern regularExpression;

    public RegexFileFilter(String regularExpression) {
        this(Pattern.compile(regularExpression));
    }

    public RegexFileFilter(Pattern regularExpression) {
        Assert.notNull(regularExpression, "The Regular Expression (Pattern) cannot be null", new Object[0]);
        this.regularExpression = regularExpression;
    }

    protected Pattern getPattern() {
        return this.regularExpression;
    }

    public String getRegularExpression() {
        return this.regularExpression.pattern();
    }

    @Override
    public boolean accept(File file) {
        return file != null && this.getPattern().matcher(FileUtils.tryGetCanonicalPathElseGetAbsolutePath(file)).matches();
    }
}

