/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.cp.elements.lang.ComparisonException;
import org.cp.elements.lang.EqualityException;
import org.cp.elements.lang.IdentityException;
import org.cp.elements.lang.IllegalTypeException;

public abstract class Assert {
    public static void argument(Boolean valid) {
        Assert.argument(valid, "argument is not valid", new Object[0]);
    }

    public static void argument(Boolean valid, String message, Object ... arguments) {
        Assert.argument(valid, new IllegalArgumentException(Assert.format(message, arguments)));
    }

    public static void argument(Boolean valid, RuntimeException e) {
        if (!Boolean.TRUE.equals(valid)) {
            throw e;
        }
    }

    public static <T extends Comparable<T>> void comparable(T obj1, T obj2) {
        Assert.comparable(obj1, obj2, "[%1$s] is not comparable to [%2$s]", obj1, obj2);
    }

    public static <T extends Comparable<T>> void comparable(T obj1, T obj2, String message, Object ... arguments) {
        Assert.comparable(obj1, obj2, new ComparisonException(Assert.format(message, arguments)));
    }

    public static <T extends Comparable<T>> void comparable(T obj1, T obj2, RuntimeException e) {
        if (obj1 == null || obj2 == null || obj1.compareTo(obj2) != 0) {
            throw e;
        }
    }

    public static void equals(Object obj1, Object obj2) {
        Assert.equals(obj1, obj2, "[%1$s] is not equal to [%2$s]", obj1, obj2);
    }

    public static void equals(Object obj1, Object obj2, String message, Object ... arguments) {
        Assert.equals(obj1, obj2, new EqualityException(Assert.format(message, arguments)));
    }

    public static void equals(Object obj1, Object obj2, RuntimeException e) {
        if (obj1 == null || !obj1.equals(obj2)) {
            throw e;
        }
    }

    public static void hasText(String value) {
        Assert.hasText(value, "argument is blank", new Object[0]);
    }

    public static void hasText(String value, String message, Object ... arguments) {
        Assert.hasText(value, new IllegalArgumentException(Assert.format(message, arguments)));
    }

    public static void hasText(String value, RuntimeException e) {
        if (value == null || value.trim().isEmpty()) {
            throw e;
        }
    }

    public static void holdsLock(Object lock) {
        Assert.holdsLock(lock, "current thread [%1$s] does not hold lock [%2$s]", Thread.currentThread().getName(), lock);
    }

    public static void holdsLock(Object lock, String message, Object ... arguments) {
        Assert.holdsLock(lock, new IllegalMonitorStateException(Assert.format(message, arguments)));
    }

    public static void holdsLock(Object lock, RuntimeException e) {
        if (lock == null || !Thread.holdsLock(lock)) {
            throw e;
        }
    }

    public static void isAssignableTo(Class<?> from, Class<?> to) {
        Assert.isAssignableTo(from, to, "[%1$s] is not assignable to [%2$s]", from, to);
    }

    public static void isAssignableTo(Class<?> from, Class<?> to, String message, Object ... arguments) {
        Assert.isAssignableTo(from, to, new ClassCastException(Assert.format(message, arguments)));
    }

    public static void isAssignableTo(Class<?> from, Class<?> to, RuntimeException e) {
        if (to == null || from != null && !to.isAssignableFrom(from)) {
            throw e;
        }
    }

    public static void isFalse(Boolean condition) {
        Assert.isFalse(condition, "condition [%1$s] is not false", condition);
    }

    public static void isFalse(Boolean condition, String message, Object ... arguments) {
        Assert.isFalse(condition, new IllegalArgumentException(Assert.format(message, arguments)));
    }

    public static void isFalse(Boolean condition, RuntimeException e) {
        if (!Boolean.FALSE.equals(condition)) {
            throw e;
        }
    }

    public static void isInstanceOf(Object obj, Class<?> type) {
        Assert.isInstanceOf(obj, type, "[%1$s] is not an instance of [%2$s]", obj, type);
    }

    public static void isInstanceOf(Object obj, Class<?> type, String message, Object ... arguments) {
        Assert.isInstanceOf(obj, type, new IllegalTypeException(Assert.format(message, arguments)));
    }

    public static void isInstanceOf(Object obj, Class<?> type, RuntimeException e) {
        if (!type.isInstance(obj)) {
            throw e;
        }
    }

    public static void isTrue(Boolean condition) {
        Assert.isTrue(condition, "condition [%1$s] is not true", condition);
    }

    public static void isTrue(Boolean condition, String message, Object ... arguments) {
        Assert.isTrue(condition, new IllegalArgumentException(Assert.format(message, arguments)));
    }

    public static void isTrue(Boolean condition, RuntimeException e) {
        if (!Boolean.TRUE.equals(condition)) {
            throw e;
        }
    }

    public static void notEmpty(String value) {
        Assert.notEmpty(value, "argument is empty", new Object[0]);
    }

    public static void notEmpty(String value, String message, Object ... arguments) {
        Assert.notEmpty(value, (RuntimeException)new IllegalArgumentException(Assert.format(message, arguments)));
    }

    public static void notEmpty(String value, RuntimeException e) {
        if ("".equals(value)) {
            throw e;
        }
    }

    public static void notEmpty(Object[] array) {
        Assert.notEmpty(array, "array is empty", new Object[0]);
    }

    public static void notEmpty(Object[] array, String message, Object ... arguments) {
        Assert.notEmpty(array, (RuntimeException)new IllegalArgumentException(Assert.format(message, arguments)));
    }

    public static void notEmpty(Object[] array, RuntimeException e) {
        if (array == null || array.length == 0) {
            throw e;
        }
    }

    public static void notEmpty(Collection<?> collection) {
        Assert.notEmpty(collection, "collection is empty", new Object[0]);
    }

    public static void notEmpty(Collection<?> collection, String message, Object ... arguments) {
        Assert.notEmpty(collection, (RuntimeException)new IllegalArgumentException(Assert.format(message, arguments)));
    }

    public static void notEmpty(Collection<?> collection, RuntimeException e) {
        if (collection == null || collection.isEmpty()) {
            throw e;
        }
    }

    public static void notEmpty(Map<?, ?> map) {
        Assert.notEmpty(map, "map is empty", new Object[0]);
    }

    public static void notEmpty(Map<?, ?> map, String message, Object ... arguments) {
        Assert.notEmpty(map, (RuntimeException)new IllegalArgumentException(Assert.format(message, arguments)));
    }

    public static void notEmpty(Map<?, ?> map, RuntimeException e) {
        if (map == null || map.isEmpty()) {
            throw e;
        }
    }

    public static void notNull(Object obj) {
        Assert.notNull(obj, "argument is null", new Object[0]);
    }

    public static void notNull(Object obj, String message, Object ... arguments) {
        Assert.notNull(obj, new IllegalArgumentException(Assert.format(message, arguments)));
    }

    public static void notNull(Object obj, RuntimeException e) {
        if (obj == null) {
            throw e;
        }
    }

    public static void same(Object obj1, Object obj2) {
        Assert.same(obj1, obj2, "[%1$s] is not the same as [%2$s]", obj1, obj2);
    }

    public static void same(Object obj1, Object obj2, String message, Object ... arguments) {
        Assert.same(obj1, obj2, new IdentityException(Assert.format(message, arguments)));
    }

    public static void same(Object obj1, Object obj2, RuntimeException e) {
        if (obj1 != obj2) {
            throw e;
        }
    }

    public static void state(Boolean valid) {
        Assert.state(valid, "state is invalid", new Object[0]);
    }

    public static void state(Boolean valid, String message, Object ... arguments) {
        Assert.state(valid, new IllegalStateException(Assert.format(message, arguments)));
    }

    public static void state(Boolean valid, RuntimeException e) {
        if (!Boolean.TRUE.equals(valid)) {
            throw e;
        }
    }

    public static void supported(Boolean supported) {
        Assert.supported(supported, "operation not supported", new Object[0]);
    }

    public static void supported(Boolean supported, String message, Object ... arguments) {
        Assert.supported(supported, new UnsupportedOperationException(Assert.format(message, arguments)));
    }

    public static void supported(Boolean supported, RuntimeException e) {
        if (!Boolean.TRUE.equals(supported)) {
            throw e;
        }
    }

    private static String format(String message, Object ... arguments) {
        return Assert.stringFormat(Assert.messageFormat(message, arguments), arguments);
    }

    private static String messageFormat(String message, Object ... arguments) {
        return arguments == null ? message : MessageFormat.format(message, arguments);
    }

    private static String stringFormat(String message, Object ... arguments) {
        return String.format(message, arguments);
    }
}

