/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang;

import java.util.concurrent.atomic.AtomicBoolean;
import org.cp.elements.util.ArrayUtils;

public abstract class BooleanUtils {
    public static boolean and(Boolean ... values) {
        boolean result;
        boolean bl = result = values != null;
        if (result) {
            for (Boolean value : values) {
                if (!(result &= BooleanUtils.valueOf(value))) break;
            }
        }
        return result;
    }

    public static boolean negate(Boolean value) {
        return !BooleanUtils.valueOf(value);
    }

    public static boolean or(Boolean ... values) {
        boolean result = false;
        for (Boolean value : ArrayUtils.nullSafeArray(values, Boolean.class)) {
            if (result |= BooleanUtils.valueOf(value)) break;
        }
        return result;
    }

    public static Boolean toBoolean(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String toString(Boolean value, String trueValue, String falseValue) {
        return BooleanUtils.valueOf(value) ? trueValue : falseValue;
    }

    public static boolean valueOf(AtomicBoolean value) {
        return value != null && value.get();
    }

    public static boolean valueOf(Boolean value) {
        return Boolean.TRUE.equals(value);
    }

    public static boolean xor(Boolean ... values) {
        boolean result = false;
        for (Boolean value : ArrayUtils.nullSafeArray(values, Boolean.class)) {
            boolean primitiveValue = BooleanUtils.valueOf(value);
            if (result && primitiveValue) {
                return false;
            }
            result |= primitiveValue;
        }
        return result;
    }
}

