/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.TypeNotFoundException;
import org.cp.elements.lang.reflect.ConstructorNotFoundException;
import org.cp.elements.lang.reflect.FieldNotFoundException;
import org.cp.elements.lang.reflect.MethodNotFoundException;
import org.cp.elements.lang.reflect.ModifierUtils;
import org.cp.elements.util.ArrayUtils;
import org.cp.elements.util.stream.StreamUtils;

public abstract class ClassUtils {
    protected static final boolean DEFAULT_INITIALIZE_LOADED_CLASS = true;
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String CLASS_FILE_EXTENSION = ".class";
    public static final String CLONE_METHOD_NAME = "clone";
    public static final String MAIN_METHOD_NAME = "main";

    public static boolean assignableTo(Class<?> fromType, Class<?> toType) {
        return toType != null && (fromType == null || toType.isAssignableFrom(fromType));
    }

    public static Class<?> getClass(Object obj) {
        return obj != null ? obj.getClass() : null;
    }

    public static String getClassName(Object obj) {
        return obj != null ? obj.getClass().getName() : null;
    }

    public static String getClassSimpleName(Object obj) {
        return obj != null ? obj.getClass().getSimpleName() : null;
    }

    public static Set<Class<?>> getInterfaces(Object obj) {
        return ClassUtils.getInterfaces(ClassUtils.getClass(obj));
    }

    public static Set<Class<?>> getInterfaces(Class type) {
        return Optional.ofNullable(type).map(theType -> ClassUtils.getInterfaces(type, new HashSet())).orElse(Collections.emptySet());
    }

    private static Set<Class<?>> getInterfaces(Class type, Set<Class<?>> interfaces) {
        if (type.getSuperclass() != null) {
            ClassUtils.getInterfaces(type.getSuperclass(), interfaces);
        }
        for (Class<?> implementedType : type.getInterfaces()) {
            if (interfaces.contains(implementedType)) continue;
            interfaces.add(implementedType);
            ClassUtils.getInterfaces(implementedType, interfaces);
        }
        return interfaces;
    }

    public static <T> Constructor<T> findConstructor(Class<T> type, Object ... arguments) {
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (ArrayUtils.nullSafeLength(arguments) != parameterTypes.length) continue;
            boolean match = true;
            for (int index = 0; match && index < parameterTypes.length; match &= ClassUtils.instanceOf(arguments[index], parameterTypes[index]), ++index) {
            }
            if (!match) continue;
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> type, Class<?> ... parameterTypes) {
        try {
            return type.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException cause) {
            throw new ConstructorNotFoundException(cause);
        }
    }

    public static <T> Constructor<T> resolveConstructor(Class<T> type, Class<?>[] parameterTypes, Object ... arguments) {
        try {
            return ClassUtils.getConstructor(type, parameterTypes);
        }
        catch (ConstructorNotFoundException cause) {
            Constructor<T> constructor = ClassUtils.findConstructor(type, arguments);
            Assert.notNull(constructor, new ConstructorNotFoundException(String.format("Failed to resolve constructor with signature [%1$s] on class type [%2$s]", ClassUtils.getMethodSignature(ClassUtils.getSimpleName(type), parameterTypes, Void.class), ClassUtils.getName(type)), cause.getCause()));
            return constructor;
        }
    }

    public static Field getField(Class<?> type, String fieldName) {
        try {
            return type.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException cause) {
            if (type.getSuperclass() != null) {
                return ClassUtils.getField(type.getSuperclass(), fieldName);
            }
            throw new FieldNotFoundException(cause);
        }
    }

    public static Method findMethod(Class<?> type, String methodName, Object ... arguments) {
        for (Method method : type.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (ArrayUtils.nullSafeLength(arguments) != parameterTypes.length) continue;
            boolean match = true;
            for (int index = 0; match && index < parameterTypes.length; match &= ClassUtils.instanceOf(arguments[index], parameterTypes[index]), ++index) {
            }
            if (!match) continue;
            return method;
        }
        return type.getSuperclass() != null ? ClassUtils.findMethod(type.getSuperclass(), methodName, arguments) : null;
    }

    public static Method getMethod(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        try {
            return type.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException cause) {
            if (type.getSuperclass() != null) {
                return ClassUtils.getMethod(type.getSuperclass(), methodName, parameterTypes);
            }
            throw new MethodNotFoundException(cause);
        }
    }

    public static Method resolveMethod(Class<?> type, String methodName, Class<?>[] parameterTypes, Object[] arguments, Class<?> returnType) {
        try {
            return ClassUtils.getMethod(type, methodName, parameterTypes);
        }
        catch (MethodNotFoundException cause) {
            Method method = ClassUtils.findMethod(type, methodName, arguments);
            Assert.notNull(method, new MethodNotFoundException(String.format("Failed to resolve method with signature [%1$s] on class type [%2$s]", ClassUtils.getMethodSignature(methodName, parameterTypes, returnType), ClassUtils.getName(type)), cause.getCause()));
            return method;
        }
    }

    protected static String getMethodSignature(Method method) {
        return ClassUtils.getMethodSignature(method.getName(), method.getParameterTypes(), method.getReturnType());
    }

    protected static String getMethodSignature(String methodName, Class<?>[] parameterTypes, Class<?> returnType) {
        StringBuilder buffer = new StringBuilder(methodName);
        buffer.append("(");
        if (parameterTypes != null) {
            int index = 0;
            for (Class<?> parameterType : parameterTypes) {
                buffer.append(index++ > 0 ? ", :" : ":");
                buffer.append(ClassUtils.getSimpleName(parameterType));
            }
        }
        buffer.append("):");
        buffer.append(returnType == null || Void.class.equals(returnType) ? "void" : ClassUtils.getSimpleName(returnType));
        return buffer.toString();
    }

    public static String getName(Class type) {
        return type != null ? type.getName() : null;
    }

    public static String getResourceName(Class type) {
        return type != null ? type.getName().replaceAll("\\.", "/").concat(CLASS_FILE_EXTENSION) : null;
    }

    public static String getSimpleName(Class type) {
        return type != null ? type.getSimpleName() : null;
    }

    public static boolean hasMainMethod(Class type) {
        return Optional.ofNullable(type).map(theType -> type.getDeclaredMethods()).map(methods -> StreamUtils.stream(methods).anyMatch(ClassUtils::isMainMethod)).orElse(false);
    }

    public static boolean implementsInterfaces(Object obj) {
        return !ClassUtils.getInterfaces(obj).isEmpty();
    }

    public static boolean implementsInterfaces(Class type) {
        return !ClassUtils.getInterfaces(type).isEmpty();
    }

    public static boolean instanceOf(Object obj, Class<?> type) {
        return type != null && type.isInstance(obj);
    }

    public static boolean isAnnotation(Class type) {
        return type != null && type.isAnnotation();
    }

    public static boolean isAnnotationPresent(Class<? extends Annotation> annotation, AnnotatedElement ... members) {
        return StreamUtils.stream(ArrayUtils.nullSafeArray(members, AnnotatedElement.class)).anyMatch(member -> member != null && member.isAnnotationPresent(annotation));
    }

    public static boolean isArray(Class type) {
        return type != null && type.isArray();
    }

    public static boolean isClass(Class type) {
        return type != null && !type.isAnnotation() && !type.isArray() && !type.isEnum() && !type.isInterface() && !type.isPrimitive();
    }

    public static boolean isConstructorWithArrayParameter(Constructor<?> constructor) {
        return constructor != null && constructor.getParameterCount() == 1 && Object[].class.isAssignableFrom(constructor.getParameterTypes()[0]);
    }

    public static boolean isDefaultConstructor(Constructor<?> constructor) {
        return ModifierUtils.isPublic(constructor) && constructor.getParameterCount() == 0;
    }

    public static boolean isEnum(Class type) {
        return type != null && type.isEnum();
    }

    public static boolean isInterface(Class type) {
        return type != null && type.isInterface();
    }

    public static boolean isMainMethod(Method method) {
        return Optional.ofNullable(method).map(localMethod -> MAIN_METHOD_NAME.equals(localMethod.getName()) && ModifierUtils.isPublic(localMethod) && ModifierUtils.isStatic(localMethod) && Void.TYPE.equals(localMethod.getReturnType()) && localMethod.getParameterCount() == 1 && localMethod.getParameterTypes()[0].equals(String[].class)).orElse(false);
    }

    public static boolean isPresent(String className) {
        try {
            return ClassUtils.loadClass(className) != null;
        }
        catch (TypeNotFoundException ignore) {
            return false;
        }
    }

    public static boolean isPrimitive(Class type) {
        return type != null && type.isPrimitive();
    }

    public static <T> Class<T> loadClass(String fullyQualifiedClassName) {
        return ClassUtils.loadClass(fullyQualifiedClassName, true, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Class<T> loadClass(String fullyQualifiedClassName, boolean initialize, ClassLoader classLoader) {
        try {
            return Class.forName(fullyQualifiedClassName, initialize, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError cause) {
            throw new TypeNotFoundException(String.format("Class [%s] was not found", fullyQualifiedClassName), cause);
        }
    }

    public static URL locateClass(String binaryName) {
        return ClassUtils.locateClass(binaryName, Thread.currentThread().getContextClassLoader());
    }

    public static URL locateClass(String binaryName, ClassLoader classLoader) {
        try {
            Class type = ClassUtils.loadClass(binaryName, false, classLoader);
            return type.getClassLoader().getResource(ClassUtils.getResourceName(type));
        }
        catch (TypeNotFoundException ignore) {
            return null;
        }
    }

    public static boolean notInstanceOf(Object obj, Class ... types) {
        boolean result = true;
        for (int index = 0; result && index < ArrayUtils.nullSafeLength(types); result &= !ClassUtils.instanceOf(obj, types[index]), ++index) {
        }
        return result;
    }

    public static Class<?> toRawType(Type type) {
        return (Class)Class.class.cast(type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type);
    }
}

