/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ClassUtils;
import org.cp.elements.lang.ElementsExceptionsFactory;
import org.cp.elements.util.stream.StreamUtils;

public enum JavaType {
    BIG_DECIMAL(BigDecimal.class),
    BIG_INTEGER(BigInteger.class),
    BOOLEAN(Boolean.class),
    BOOLEAN_TYPE(Boolean.TYPE),
    BYTE(Byte.class),
    BYTE_TYPE(Byte.TYPE),
    CHARACTER(Character.class),
    CHARACTER_TYPE(Character.TYPE),
    DOUBLE(Double.class),
    DOUBLE_TYPE(Double.TYPE),
    FLOAT(Float.class),
    FLOAT_TYPE(Float.TYPE),
    INTEGER(Integer.class),
    INTEGER_TYPE(Integer.TYPE),
    LONG(Long.class),
    LONG_TYPE(Long.TYPE),
    NUMBER(Number.class),
    SHORT(Short.class),
    SHORT_TYPE(Short.TYPE),
    STRING(String.class),
    THREAD(Thread.class),
    THROWABLE(Throwable.class);

    private final Class type;

    public static boolean isJavaType(Object obj) {
        return StreamUtils.stream(JavaType.values()).anyMatch(javaType -> javaType.getType().isInstance(obj));
    }

    public static boolean isJavaType(Class<?> type) {
        return StreamUtils.stream(JavaType.values()).anyMatch(javaType -> type != null && ClassUtils.assignableTo(type, javaType.getType()));
    }

    public static JavaType valueOf(Class<?> type) {
        return StreamUtils.stream(JavaType.values()).filter(javaType -> javaType.getType().equals(type)).findFirst().orElseThrow(() -> ElementsExceptionsFactory.newTypeNotFoundException("No JavaType found for class type [%s]", ClassUtils.getName(type)));
    }

    private JavaType(Class type) {
        Assert.notNull(type, "Class type cannot be null", new Object[0]);
        this.type = type;
    }

    public Class getType() {
        return this.type;
    }

    public String toString() {
        return this.getType().getName();
    }
}

