/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.AssertionException;
import org.cp.elements.lang.Condition;
import org.cp.elements.lang.FluentApiExtension;
import org.cp.elements.lang.LogicalOperator;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.lang.StringUtils;
import org.cp.elements.lang.Transformer;
import org.cp.elements.lang.annotation.Experimental;
import org.cp.elements.lang.annotation.FluentApi;
import org.cp.elements.lang.reflect.MethodInterceptor;
import org.cp.elements.lang.reflect.MethodInvocation;
import org.cp.elements.lang.reflect.ProxyFactory;

public abstract class LangExtensions {
    @FluentApi
    @Experimental
    public static <T> T $(T obj, Class<?> ... interfaces) {
        ProxyFactory<T> proxyFactory = ProxyFactory.newProxyFactory(obj, interfaces);
        return (T)proxyFactory.adviseWith(SafeNavigationHandler.newSafeNavigationHandler(proxyFactory)).newProxy();
    }

    @FluentApi
    public static <T> AssertThat<T> assertThat(T obj) {
        return new AssertThatExpression(obj);
    }

    @FluentApi
    public static <T> Is<T> is(T obj) {
        return new IsExpression(obj);
    }

    private static final class IsExpression<T>
    implements Is<T> {
        private static final boolean DEFAULT_EXPECTED = true;
        private final boolean expected;
        private final T obj;

        private IsExpression(T obj) {
            this(obj, true);
        }

        private IsExpression(T obj, boolean expected) {
            this.obj = obj;
            this.expected = expected;
        }

        private boolean equalToExpected(boolean actualOutcome) {
            return actualOutcome == this.expected;
        }

        private LogicalOperator getOp(LogicalOperator op) {
            return this.expected ? op : op.getOpposite();
        }

        private Class<?> toClass(Object obj) {
            return obj instanceof Class ? (Class<?>)obj : obj.getClass();
        }

        private Comparable<T> toComparable(T obj) {
            return (Comparable)obj;
        }

        @Override
        public boolean assignableTo(Class<?> type) {
            return this.equalToExpected(this.obj != null && type != null && type.isAssignableFrom(this.toClass(this.obj)));
        }

        @Override
        public boolean comparableTo(T obj) {
            return this.equalToExpected(this.toComparable(this.obj).compareTo(obj) == 0);
        }

        @Override
        public boolean equalTo(T obj) {
            return this.equalToExpected(this.obj != null && this.obj.equals(obj));
        }

        @Override
        public boolean notEqualTo(T obj) {
            return this.not().equalTo(obj);
        }

        @Override
        public boolean False() {
            return this.equalToExpected(Boolean.FALSE.equals(this.obj));
        }

        @Override
        public boolean greaterThan(T lowerBound) {
            return this.equalToExpected(this.toComparable(this.obj).compareTo(lowerBound) > 0);
        }

        @Override
        public boolean greaterThanAndLessThan(T lowerBound, T upperBound) {
            return this.getOp(LogicalOperator.AND).evaluate(this.greaterThan(lowerBound), this.lessThan(upperBound));
        }

        @Override
        public boolean greaterThanAndLessThanEqualTo(T lowerBound, T upperBound) {
            return this.getOp(LogicalOperator.AND).evaluate(this.greaterThan(lowerBound), this.lessThanEqualTo(upperBound));
        }

        @Override
        public boolean greaterThanEqualTo(T lowerBound) {
            return this.equalToExpected(this.toComparable(this.obj).compareTo(lowerBound) >= 0);
        }

        @Override
        public boolean greaterThanEqualToAndLessThan(T lowerBound, T upperBound) {
            return this.getOp(LogicalOperator.AND).evaluate(this.greaterThanEqualTo(lowerBound), this.lessThan(upperBound));
        }

        @Override
        public boolean greaterThanEqualToAndLessThanEqualTo(T lowerBound, T upperBound) {
            return this.getOp(LogicalOperator.AND).evaluate(this.greaterThanEqualTo(lowerBound), this.lessThanEqualTo(upperBound));
        }

        @Override
        public boolean instanceOf(Class type) {
            return this.equalToExpected(type != null && type.isInstance(this.obj));
        }

        @Override
        public boolean lessThan(T upperBound) {
            return this.equalToExpected(this.toComparable(this.obj).compareTo(upperBound) < 0);
        }

        @Override
        public boolean lessThanOrGreaterThan(T upperBound, T lowerBound) {
            return this.getOp(LogicalOperator.OR).evaluate(this.lessThan(upperBound), this.greaterThan(lowerBound));
        }

        @Override
        public boolean lessThanOrGreaterThanEqualTo(T upperBound, T lowerBound) {
            return this.getOp(LogicalOperator.OR).evaluate(this.lessThan(upperBound), this.greaterThanEqualTo(lowerBound));
        }

        @Override
        public boolean lessThanEqualTo(T upperBound) {
            return this.equalToExpected(this.toComparable(this.obj).compareTo(upperBound) <= 0);
        }

        @Override
        public boolean lessThanEqualToOrGreaterThan(T upperBound, T lowerBound) {
            return this.getOp(LogicalOperator.OR).evaluate(this.lessThanEqualTo(upperBound), this.greaterThan(lowerBound));
        }

        @Override
        public boolean lessThanEqualToOrGreaterThanEqualTo(T upperBound, T lowerBound) {
            return this.getOp(LogicalOperator.OR).evaluate(this.lessThanEqualTo(upperBound), this.greaterThanEqualTo(lowerBound));
        }

        @Override
        public boolean notBlank() {
            return StringUtils.hasText(ObjectUtils.toString(this.obj));
        }

        @Override
        public boolean notEmpty() {
            boolean result = this.obj instanceof Object[] && ((Object[])this.obj).length != 0;
            result |= this.obj instanceof Collection && !((Collection)this.obj).isEmpty();
            result |= this.obj instanceof Map && !((Map)this.obj).isEmpty();
            return result |= this.obj instanceof String && !this.obj.toString().isEmpty();
        }

        @Override
        public boolean notNull() {
            return this.not().Null();
        }

        @Override
        public boolean Null() {
            return this.equalToExpected(this.obj == null);
        }

        @Override
        public boolean notSameAs(T obj) {
            return this.not().sameAs(obj);
        }

        @Override
        public boolean sameAs(T obj) {
            return this.equalToExpected(this.obj == obj);
        }

        @Override
        public boolean True() {
            return this.equalToExpected(Boolean.TRUE.equals(this.obj));
        }

        @Override
        public Is<T> not() {
            return new IsExpression<T>(this.obj, !this.expected);
        }
    }

    public static interface Is<T>
    extends FluentApiExtension {
        public boolean assignableTo(Class<?> var1);

        public boolean comparableTo(T var1);

        public boolean equalTo(T var1);

        public boolean notEqualTo(T var1);

        public boolean False();

        public boolean greaterThan(T var1);

        public boolean greaterThanAndLessThan(T var1, T var2);

        public boolean greaterThanAndLessThanEqualTo(T var1, T var2);

        public boolean greaterThanEqualTo(T var1);

        public boolean greaterThanEqualToAndLessThan(T var1, T var2);

        public boolean greaterThanEqualToAndLessThanEqualTo(T var1, T var2);

        public boolean instanceOf(Class var1);

        public boolean lessThan(T var1);

        public boolean lessThanOrGreaterThan(T var1, T var2);

        public boolean lessThanOrGreaterThanEqualTo(T var1, T var2);

        public boolean lessThanEqualTo(T var1);

        public boolean lessThanEqualToOrGreaterThan(T var1, T var2);

        public boolean lessThanEqualToOrGreaterThanEqualTo(T var1, T var2);

        public boolean notBlank();

        public boolean notEmpty();

        public boolean notNull();

        public boolean Null();

        public boolean sameAs(T var1);

        public boolean notSameAs(T var1);

        public boolean True();

        public Is<T> not();
    }

    public static class AssertThatWrapper<T>
    implements AssertThat<T> {
        private final AssertThat<T> delegate;

        public AssertThatWrapper(AssertThat<T> delegate) {
            Assert.notNull(delegate, "Delegate must not be null", new Object[0]);
            this.delegate = delegate;
        }

        public static <T> AssertThat<T> wrap(AssertThat<T> delegate) {
            return new AssertThatWrapper<T>(delegate);
        }

        protected AssertThat<T> getDelegate() {
            return this.delegate;
        }

        @Override
        public void isAssignableTo(Class type) {
            this.getDelegate().isAssignableTo(type);
        }

        @Override
        public void isComparableTo(Comparable<T> obj) {
            this.getDelegate().isComparableTo(obj);
        }

        @Override
        public void isEqualTo(T obj) {
            this.getDelegate().isEqualTo(obj);
        }

        @Override
        public void isNotEqualTo(T obj) {
            this.getDelegate().isNotEqualTo(obj);
        }

        @Override
        public void isFalse() {
            this.getDelegate().isFalse();
        }

        @Override
        public void isGreaterThan(T lowerBound) {
            this.getDelegate().isGreaterThan(lowerBound);
        }

        @Override
        public void isGreaterThanAndLessThan(T lowerBound, T upperBound) {
            this.getDelegate().isGreaterThanAndLessThan(lowerBound, upperBound);
        }

        @Override
        public void isGreaterThanAndLessThanEqualTo(T lowerBound, T upperBound) {
            this.getDelegate().isGreaterThanAndLessThanEqualTo(lowerBound, upperBound);
        }

        @Override
        public void isGreaterThanEqualTo(T lowerBound) {
            this.getDelegate().isGreaterThanEqualTo(lowerBound);
        }

        @Override
        public void isGreaterThanEqualToAndLessThan(T lowerBound, T upperBound) {
            this.getDelegate().isGreaterThanEqualToAndLessThan(lowerBound, upperBound);
        }

        @Override
        public void isGreaterThanEqualToAndLessThanEqualTo(T lowerBound, T upperBound) {
            this.getDelegate().isGreaterThanEqualToAndLessThanEqualTo(lowerBound, upperBound);
        }

        @Override
        public void hasText() {
            this.getDelegate().hasText();
        }

        @Override
        public void holdsLock(Object lock) {
            this.getDelegate().holdsLock(lock);
        }

        @Override
        public void isInstanceOf(Class type) {
            this.getDelegate().isInstanceOf(type);
        }

        @Override
        public void isLessThan(T upperBound) {
            this.getDelegate().isLessThan(upperBound);
        }

        @Override
        public void isLessThanOrGreaterThan(T upperBound, T lowerBound) {
            this.getDelegate().isLessThanOrGreaterThan(upperBound, lowerBound);
        }

        @Override
        public void isLessThanOrGreaterThanEqualTo(T upperBound, T lowerBound) {
            this.getDelegate().isLessThanOrGreaterThanEqualTo(upperBound, lowerBound);
        }

        @Override
        public void isLessThanEqualTo(T upperBound) {
            this.getDelegate().isLessThanEqualTo(upperBound);
        }

        @Override
        public void isLessThanEqualToOrGreaterThan(T upperBound, T lowerBound) {
            this.getDelegate().isLessThanEqualToOrGreaterThan(upperBound, lowerBound);
        }

        @Override
        public void isLessThanEqualToOrGreaterThanEqualTo(T upperBound, T lowerBound) {
            this.getDelegate().isLessThanEqualToOrGreaterThanEqualTo(upperBound, lowerBound);
        }

        @Override
        public void isNotBlank() {
            this.getDelegate().isNotBlank();
        }

        @Override
        public void isNotEmpty() {
            this.getDelegate().isNotEmpty();
        }

        @Override
        public void isNotNull() {
            this.getDelegate().isNotNull();
        }

        @Override
        public void isNull() {
            this.getDelegate().isNull();
        }

        @Override
        public void isSameAs(T obj) {
            this.getDelegate().isSameAs(obj);
        }

        @Override
        public void isNotSameAs(T obj) {
            this.getDelegate().isNotSameAs(obj);
        }

        @Override
        public void isTrue() {
            this.getDelegate().isTrue();
        }

        @Override
        public AssertThat<T> not() {
            return new AssertThatWrapper<T>(this.getDelegate().not());
        }

        @Override
        public AssertThat<T> throwing(RuntimeException e) {
            this.getDelegate().throwing(e);
            return this;
        }

        @Override
        public AssertThat<T> transform(Transformer<AssertThat<T>> assertionTransformer) {
            return new AssertThatWrapper<T>(assertionTransformer.transform(this.getDelegate()));
        }

        @Override
        public AssertThat<T> stating(String message, Object ... args) {
            this.getDelegate().stating(message, args);
            return this;
        }

        @Override
        public AssertThat<T> when(Condition condition) {
            this.getDelegate().when(condition);
            return this;
        }
    }

    private static final class AssertThatExpression<T>
    implements AssertThat<T> {
        private static final boolean DEFAULT_EXPECTED = true;
        private static final String NOT = "not ";
        private final boolean expected;
        private final T obj;
        private Condition condition;
        private RuntimeException cause;
        private String message;
        private Transformer<AssertThat<T>> transformer;

        private AssertThatExpression(T obj) {
            this(obj, true);
        }

        private AssertThatExpression(T obj, boolean expected) {
            this.obj = obj;
            this.expected = expected;
            this.condition = () -> true;
        }

        private boolean conditionHolds() {
            return this.condition.evaluate();
        }

        private boolean notEqualToExpected(boolean actual) {
            return actual != this.expected;
        }

        @Override
        public void isAssignableTo(Class type) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).assignableTo(type))) {
                this.throwAssertionError("[%1$s] is %2$sassignable to [%3$s]", this.obj, this.negate(NOT), ObjectUtils.getName(type));
            }
        }

        @Override
        public void isComparableTo(Comparable<T> comparable) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is((Comparable)this.obj).comparableTo(comparable))) {
                this.throwAssertionError("[%1$s] is %2$scomparable to [%3$s]", this.obj, this.negate(NOT), comparable);
            }
        }

        @Override
        public void isEqualTo(T obj) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).equalTo(obj))) {
                this.throwAssertionError("[%1$s] is %2$sequal to [%3$s]", this.obj, this.negate(NOT), obj);
            }
        }

        @Override
        public void isNotEqualTo(T obj) {
            this.not().isEqualTo(obj);
        }

        @Override
        public void isFalse() {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).False())) {
                this.throwAssertionError("[%1$s] is %2$sfalse", this.obj, this.negate(NOT));
            }
        }

        @Override
        public void isGreaterThan(T lowerBound) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).greaterThan(lowerBound))) {
                this.throwAssertionError("[%1$s] is %2$sgreater than [%3$s]", this.obj, this.negate(NOT), lowerBound);
            }
        }

        @Override
        public void isGreaterThanAndLessThan(T lowerBound, T upperBound) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).greaterThanAndLessThan(lowerBound, upperBound))) {
                this.throwAssertionError("[%1$s] is %2$sgreater than [%3$s] and less than [%4$s]", this.obj, this.negate(NOT), lowerBound, upperBound);
            }
        }

        @Override
        public void isGreaterThanAndLessThanEqualTo(T lowerBound, T upperBound) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).greaterThanAndLessThanEqualTo(lowerBound, upperBound))) {
                this.throwAssertionError("[%1$s] is %2$sgreater than [%3$s] and less than equal to [%4$s]", this.obj, this.negate(NOT), lowerBound, upperBound);
            }
        }

        @Override
        public void isGreaterThanEqualTo(T lowerBound) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).greaterThanEqualTo(lowerBound))) {
                this.throwAssertionError("[%1$s] is %2$sgreater than equal to [%3$s]", this.obj, this.negate(NOT), lowerBound);
            }
        }

        @Override
        public void isGreaterThanEqualToAndLessThan(T lowerBound, T upperBound) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).greaterThanEqualToAndLessThan(lowerBound, upperBound))) {
                this.throwAssertionError("[%1$s] is %2$sgreater than equal to [%3$s] and less than [%4$s]", this.obj, this.negate(NOT), lowerBound, upperBound);
            }
        }

        @Override
        public void isGreaterThanEqualToAndLessThanEqualTo(T lowerBound, T upperBound) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).greaterThanEqualToAndLessThanEqualTo(lowerBound, upperBound))) {
                this.throwAssertionError("[%1$s] is %2$sgreater than equal to [%3$s] and less than equal to [%4$s]", this.obj, this.negate(NOT), lowerBound, upperBound);
            }
        }

        @Override
        public void hasText() {
            this.isNotBlank();
        }

        @Override
        public void holdsLock(Object lock) {
            if (this.conditionHolds() && this.notEqualToExpected(Thread.holdsLock(lock))) {
                this.throwAssertionError("[%1$s] %2$slock [%3$s]", Thread.currentThread(), this.expected ? "does not hold " : "holds ", lock);
            }
        }

        @Override
        public void isInstanceOf(Class type) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).instanceOf(type))) {
                this.throwAssertionError("[%1$s] is %2$san instance of [%3$s]", this.obj, this.negate(NOT), ObjectUtils.getName(type));
            }
        }

        @Override
        public void isLessThan(T upperBound) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).lessThan(upperBound))) {
                this.throwAssertionError("[%1$s] is %2$sless than [%3$s]", this.obj, this.negate(NOT), upperBound);
            }
        }

        @Override
        public void isLessThanOrGreaterThan(T upperBound, T lowerBound) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).lessThanOrGreaterThan(upperBound, lowerBound))) {
                this.throwAssertionError("[%1$s] is %2$sless than [%3$s] or greater than [%4$s]", this.obj, this.negate(NOT), upperBound, lowerBound);
            }
        }

        @Override
        public void isLessThanOrGreaterThanEqualTo(T upperBound, T lowerBound) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).lessThanOrGreaterThanEqualTo(upperBound, lowerBound))) {
                this.throwAssertionError("[%1$s] is %2$sless than [%3$s] or greater than equal to [%4$s]", this.obj, this.negate(NOT), upperBound, lowerBound);
            }
        }

        @Override
        public void isLessThanEqualTo(T upperBound) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).lessThanEqualTo(upperBound))) {
                this.throwAssertionError("[%1$s] is %2$sless than equal to [%3$s]", this.obj, this.negate(NOT), upperBound);
            }
        }

        @Override
        public void isLessThanEqualToOrGreaterThan(T upperBound, T lowerBound) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).lessThanEqualToOrGreaterThan(upperBound, lowerBound))) {
                this.throwAssertionError("[%1$s] is %2$sless than equal to [%3$s] or greater than [%4$s]", this.obj, this.negate(NOT), upperBound, lowerBound);
            }
        }

        @Override
        public void isLessThanEqualToOrGreaterThanEqualTo(T upperBound, T lowerBound) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).lessThanEqualToOrGreaterThanEqualTo(upperBound, lowerBound))) {
                this.throwAssertionError("[%1$s] is %2$sless than equal to [%3$s] or greater than equal to [%4$s]", this.obj, this.negate(NOT), upperBound, lowerBound);
            }
        }

        @Override
        public void isNotBlank() {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).notBlank())) {
                this.throwAssertionError("[%1$s] is %2$sblank", this.obj, this.expected ? "" : NOT);
            }
        }

        @Override
        public void isNotEmpty() {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).notEmpty())) {
                this.throwAssertionError("[%1$s] is %2$sempty", this.obj, this.expected ? "" : NOT);
            }
        }

        @Override
        public void isNotNull() {
            this.not().isNull();
        }

        @Override
        public void isNull() {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).Null())) {
                this.throwAssertionError("[%1$s] is %2$snull", this.obj, this.negate(NOT));
            }
        }

        @Override
        public void isSameAs(T obj) {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).sameAs(obj))) {
                this.throwAssertionError("[%1$s] is %2$sthe same as [%3$s]", this.obj, this.negate(NOT), obj);
            }
        }

        @Override
        public void isNotSameAs(T obj) {
            this.not().isSameAs(obj);
        }

        @Override
        public void isTrue() {
            if (this.conditionHolds() && this.notEqualToExpected(LangExtensions.is(this.obj).True())) {
                this.throwAssertionError("[%1$s] is %2$strue", this.obj, this.negate(NOT));
            }
        }

        @Override
        public AssertThat<T> not() {
            AssertThat<T> expression = new AssertThatExpression<T>(this.obj, !this.expected);
            expression = this.transformer != null ? (AssertThat)this.transformer.transform(expression) : expression;
            expression = expression.throwing(this.cause);
            expression = this.message != null ? expression.stating(this.message, new Object[0]) : expression;
            expression = expression.when(this.condition);
            return expression;
        }

        @Override
        public AssertThat<T> stating(String message, Object ... args) {
            this.message = this.format(message, args);
            return this;
        }

        @Override
        public AssertThat<T> throwing(RuntimeException cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public AssertThat<T> transform(Transformer<AssertThat<T>> assertionTransformer) {
            this.transformer = assertionTransformer;
            return assertionTransformer.transform(this);
        }

        @Override
        public AssertThat<T> when(Condition condition) {
            this.condition = condition != null ? condition : () -> true;
            return this;
        }

        private String format(String message, Object ... args) {
            return this.stringFormat(this.messageFormat(message, args), args);
        }

        private String messageFormat(String message, Object ... args) {
            return MessageFormat.format(message, args);
        }

        private String stringFormat(String message, Object ... args) {
            return String.format(message, args);
        }

        private String negate(String value) {
            return this.expected ? value : "";
        }

        private void throwAssertionError(String defaultMessage, Object ... args) {
            throw ObjectUtils.returnValueOrDefaultIfNull(this.cause, () -> new AssertionException(this.withMessage(defaultMessage, args)));
        }

        private String withMessage(String defaultMessage, Object ... args) {
            return LangExtensions.is(this.message).notBlank() ? this.message : this.format(defaultMessage, args);
        }
    }

    public static interface AssertThat<T>
    extends FluentApiExtension {
        public void isAssignableTo(Class var1);

        public void isComparableTo(Comparable<T> var1);

        public void isEqualTo(T var1);

        public void isNotEqualTo(T var1);

        public void isFalse();

        public void isGreaterThan(T var1);

        public void isGreaterThanAndLessThan(T var1, T var2);

        public void isGreaterThanAndLessThanEqualTo(T var1, T var2);

        public void isGreaterThanEqualTo(T var1);

        public void isGreaterThanEqualToAndLessThan(T var1, T var2);

        public void isGreaterThanEqualToAndLessThanEqualTo(T var1, T var2);

        public void hasText();

        public void holdsLock(Object var1);

        public void isInstanceOf(Class var1);

        public void isLessThan(T var1);

        public void isLessThanOrGreaterThan(T var1, T var2);

        public void isLessThanOrGreaterThanEqualTo(T var1, T var2);

        public void isLessThanEqualTo(T var1);

        public void isLessThanEqualToOrGreaterThan(T var1, T var2);

        public void isLessThanEqualToOrGreaterThanEqualTo(T var1, T var2);

        public void isNotBlank();

        public void isNotEmpty();

        public void isNotNull();

        public void isNull();

        public void isSameAs(T var1);

        public void isNotSameAs(T var1);

        public void isTrue();

        public AssertThat<T> not();

        public AssertThat<T> stating(String var1, Object ... var2);

        public AssertThat<T> throwing(RuntimeException var1);

        public AssertThat<T> transform(Transformer<AssertThat<T>> var1);

        public AssertThat<T> when(Condition var1);
    }

    protected static class SafeNavigationHandler<T>
    implements FluentApiExtension,
    MethodInterceptor<T> {
        private static final Object DUMMY = new Object();
        private final ProxyFactory<T> proxyFactory;

        static <T> SafeNavigationHandler newSafeNavigationHandler(ProxyFactory<T> proxyFactory) {
            return new SafeNavigationHandler<T>(proxyFactory);
        }

        private SafeNavigationHandler(ProxyFactory<T> proxyFactory) {
            Assert.notNull(proxyFactory, "ProxyFactory must not be null", new Object[0]);
            this.proxyFactory = proxyFactory;
        }

        private ProxyFactory<T> getProxyFactory() {
            return this.proxyFactory;
        }

        @Override
        public T getTarget() {
            return this.getProxyFactory().getTarget();
        }

        @Override
        public <R> Optional<R> intercept(MethodInvocation methodInvocation) {
            R nextTarget = this.resolveNextTarget(methodInvocation);
            Class<?> targetType = this.resolveTargetType(methodInvocation);
            return this.canProxy(nextTarget, targetType) ? Optional.of(LangExtensions.$(nextTarget, targetType)) : Optional.ofNullable(nextTarget);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.intercept(MethodInvocation.newMethodInvocation(this.resolveTarget(proxy), method, args)).orElse(null);
        }

        private <R> R resolveNextTarget(MethodInvocation methodInvocation) {
            return Optional.ofNullable(this.getTarget()).map(target -> methodInvocation.makeAccessible().invoke(target).orElse(null)).orElse(null);
        }

        private Object resolveTarget(Object proxy) {
            return Optional.ofNullable(this.getTarget()).orElse(proxy);
        }

        private Class<?> resolveTargetType(MethodInvocation methodInvocation) {
            return methodInvocation.getMethod().getReturnType();
        }

        private boolean canProxy(Object target, Class<?> ... types) {
            return this.getProxyFactory().canProxy(Optional.ofNullable(target).orElse(DUMMY), types);
        }
    }
}

