/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang;

import java.util.function.Supplier;
import org.cp.elements.lang.Assert;

public abstract class LogicalOperator {
    public static final LogicalOperator AND = new LogicalAnd();
    public static final LogicalOperator OR = new LogicalOr();
    public static final LogicalOperator XOR = new LogicalXor();

    public static LogicalOperator negate(LogicalOperator op) {
        return new LogicalNot(op.getOpposite());
    }

    public abstract boolean isBinary();

    public abstract boolean isTernary();

    public abstract boolean isUnary();

    public abstract String getDescription();

    public abstract LogicalOperator getOpposite();

    public abstract String getSymbol();

    public abstract boolean evaluate(boolean ... var1);

    public abstract boolean evaluate(Supplier<Boolean> ... var1);

    public String toString() {
        return this.getDescription();
    }

    static final class LogicalXor
    extends AbstractLogicalOperator {
        LogicalXor() {
            super("xor", "^");
        }

        @Override
        public boolean isBinary() {
            return true;
        }

        @Override
        public LogicalOperator getOpposite() {
            return this;
        }

        @Override
        public boolean evaluate(boolean ... conditions) {
            int count = 0;
            for (int index = 0; index < conditions.length && count < 2; ++index) {
                if (!conditions[index]) continue;
                ++count;
            }
            return count == 1;
        }

        @Override
        @SafeVarargs
        public final boolean evaluate(Supplier<Boolean> ... suppliers) {
            int count = 0;
            for (int index = 0; index < suppliers.length && count < 2; ++index) {
                if (!Boolean.TRUE.equals(suppliers[index].get())) continue;
                ++count;
            }
            return count == 1;
        }
    }

    static final class LogicalOr
    extends AbstractLogicalOperator {
        LogicalOr() {
            super("or", "||");
        }

        @Override
        public boolean isBinary() {
            return true;
        }

        @Override
        public LogicalOperator getOpposite() {
            return AND;
        }

        @Override
        public boolean evaluate(boolean ... conditions) {
            for (boolean condition : conditions) {
                if (!condition) continue;
                return true;
            }
            return false;
        }

        @Override
        @SafeVarargs
        public final boolean evaluate(Supplier<Boolean> ... suppliers) {
            for (Supplier<Boolean> supplier : suppliers) {
                if (!Boolean.TRUE.equals(supplier.get())) continue;
                return true;
            }
            return false;
        }
    }

    static final class LogicalNot
    extends AbstractLogicalOperator {
        private final LogicalOperator op;

        LogicalNot(LogicalOperator op) {
            super("not", "!");
            Assert.notNull(op, "The LogicalOperator to negate cannot be null", new Object[0]);
            this.op = op;
        }

        @Override
        public boolean isUnary() {
            return true;
        }

        LogicalOperator getOp() {
            return this.op;
        }

        @Override
        public LogicalOperator getOpposite() {
            return this;
        }

        @Override
        public boolean evaluate(boolean ... conditions) {
            return !this.op.evaluate(conditions);
        }

        @Override
        @SafeVarargs
        public final boolean evaluate(Supplier<Boolean> ... suppliers) {
            return !this.op.evaluate(suppliers);
        }
    }

    static final class LogicalAnd
    extends AbstractLogicalOperator {
        LogicalAnd() {
            super("and", "&&");
        }

        @Override
        public boolean isBinary() {
            return true;
        }

        @Override
        public LogicalOperator getOpposite() {
            return OR;
        }

        @Override
        public boolean evaluate(boolean ... conditions) {
            for (boolean condition : conditions) {
                if (condition) continue;
                return false;
            }
            return true;
        }

        @Override
        @SafeVarargs
        public final boolean evaluate(Supplier<Boolean> ... suppliers) {
            for (Supplier<Boolean> supplier : suppliers) {
                if (Boolean.TRUE.equals(supplier.get())) continue;
                return false;
            }
            return true;
        }
    }

    protected static abstract class AbstractLogicalOperator
    extends LogicalOperator {
        private final String description;
        private final String symbol;

        protected AbstractLogicalOperator(String description, String symbol) {
            Assert.hasText(description, "The description of this logical operator must be specified", new Object[0]);
            Assert.hasText(symbol, "The symbolic representation of this logical operator must be specified", new Object[0]);
            this.description = description;
            this.symbol = symbol;
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public boolean isTernary() {
            return false;
        }

        @Override
        public boolean isUnary() {
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public LogicalOperator getOpposite() {
            throw new UnsupportedOperationException("Not Implemented");
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }
    }
}

