/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang;

import java.math.BigInteger;
import org.cp.elements.lang.Assert;

public abstract class MathUtils {
    public static final BigInteger NEGATIVE_ONE = BigInteger.ONE.negate();
    public static final BigInteger TWO = BigInteger.valueOf(2L);
    protected static final String NUMBER_LESS_THAN_ZERO_ERROR_MESSAGE = "value (%1$d) must be greater than equal to 0";

    public static double circleArea(double radius) {
        return MathUtils.ellipseArea(radius, radius);
    }

    public static double circleCircumference(double radius) {
        return Math.PI * 2 * radius;
    }

    public static double circleDiameter(double radius) {
        return 2.0 * radius;
    }

    public static double coneVolume(double radius, double height) {
        return Math.PI * Math.pow(radius, 2.0) * height / 3.0;
    }

    public static double cubeSurfaceArea(double side) {
        return 6.0 * MathUtils.squareArea(side);
    }

    public static double cubeVolume(double side) {
        return Math.pow(side, 3.0);
    }

    public static double cylinderSurfaceArea(double radius, double height) {
        return Math.PI * 2 * Math.pow(radius, 2.0) + Math.PI * 2 * radius * height;
    }

    public static double cylinderVolume(double radius, double height) {
        return Math.PI * Math.pow(radius, 2.0) * height;
    }

    public static double ellipseArea(double radiusLength, double radiusHeight) {
        return Math.PI * radiusLength * radiusHeight;
    }

    public static double ellipsoidVolume(double radiusLength, double radiusHeight, double radiusWidth) {
        return Math.PI * 4 * radiusLength * radiusHeight * radiusWidth / 3.0;
    }

    public static double equilateralTriangleArea(double side) {
        return Math.sqrt(3.0) / 4.0 * Math.pow(side, 2.0);
    }

    public static BigInteger factorial(BigInteger value) {
        Assert.notNull(value, "value must not be null", new Object[0]);
        Assert.isTrue(value.compareTo(BigInteger.ZERO) >= 0, String.format(NUMBER_LESS_THAN_ZERO_ERROR_MESSAGE, value), new Object[0]);
        if (value.compareTo(TWO) <= 0) {
            return value.equals(TWO) ? TWO : BigInteger.ONE;
        }
        BigInteger result = value;
        value = result.add(NEGATIVE_ONE);
        while (value.compareTo(BigInteger.ONE) > 0) {
            result = result.multiply(value);
            value = value.add(NEGATIVE_ONE);
        }
        return result;
    }

    public static int fibonacciNumber(int n) {
        return MathUtils.fibonacciSequence(n)[n - 1];
    }

    public static int[] fibonacciSequence(int n) {
        Assert.argument(n > 0, "The number of elements from the Fibonacci Sequence to calculate must be greater than equal to 0!", new Object[0]);
        int[] fibonacciNumbers = new int[n];
        for (int position = 0; position < n; ++position) {
            fibonacciNumbers[position] = position == 0 ? 0 : (position < 2 ? 1 : fibonacciNumbers[position - 1] + fibonacciNumbers[position - 2]);
        }
        return fibonacciNumbers;
    }

    public static double irregularPrismVolume(double base, double height) {
        return base * height;
    }

    public static double max(double ... values) {
        double maxValue = Double.NaN;
        if (values != null) {
            for (double value : values) {
                maxValue = Double.isNaN(maxValue) ? value : Math.max(maxValue, value);
            }
        }
        return maxValue;
    }

    public static double min(double ... values) {
        double minValue = Double.NaN;
        if (values != null) {
            for (double value : values) {
                minValue = Double.isNaN(minValue) ? value : Math.min(minValue, value);
            }
        }
        return minValue;
    }

    public static int multiply(int ... numbers) {
        int result = 0;
        if (numbers != null) {
            result = numbers.length > 0 ? 1 : 0;
            for (int number : numbers) {
                result *= number;
            }
        }
        return result;
    }

    public static double parallelogramArea(double base, double height) {
        return MathUtils.rectangleArea(base, height);
    }

    public static double pyramidVolume(double base, double height) {
        return base * height / 3.0;
    }

    public static double pythagoreanTheorem(double a, double b) {
        return Math.sqrt(Math.pow(a, 2.0) + Math.pow(b, 2.0));
    }

    public static double rectangleArea(double length, double height) {
        return length * height;
    }

    public static double rectangularPrismSurfaceArea(double length, double height, double width) {
        return 2.0 * length * height + 2.0 * length * width + 2.0 * height * width;
    }

    public static double rectangularPrismVolume(double length, double height, double width) {
        return length * height * width;
    }

    public static double roundToNearestTenth(double value) {
        value *= 10.0;
        value = Math.round(value);
        return value /= 10.0;
    }

    public static double sphereSurfaceArea(double radius) {
        return Math.PI * 4 * Math.pow(radius, 2.0);
    }

    public static double sphereVolume(double radius) {
        return Math.PI * 4 * Math.pow(radius, 3.0) / 3.0;
    }

    public static double squareArea(double side) {
        return MathUtils.rectangleArea(side, side);
    }

    public static int sum(int ... numbers) {
        int sum = 0;
        if (numbers != null) {
            for (int number : numbers) {
                sum += number;
            }
        }
        return sum;
    }

    public static double trapezoidArea(double height, double baseOne, double baseTwo) {
        return height / 2.0 * (baseOne + baseTwo);
    }

    public static double triangleArea(double base, double height) {
        return base * height / 2.0;
    }
}

