/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang;

import java.math.BigInteger;

public abstract class NumberUtils {
    public static byte[] getBytes(int value) {
        byte[] valueBytes = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return valueBytes;
    }

    public static boolean isDecimal(double value) {
        return Math.floor(value) != value;
    }

    public static boolean isDecimal(Number value) {
        return value instanceof Float || value instanceof Double;
    }

    public static boolean isEven(long value) {
        return Math.abs(value) % 2L == 0L;
    }

    public static boolean isBitwiseEven(long value) {
        return (1L & Math.abs(value)) == 0L;
    }

    public static boolean isNegative(double value) {
        return value < 0.0;
    }

    public static boolean isOdd(long value) {
        return Math.abs(value) % 2L == 1L;
    }

    public static boolean isBitwiseOdd(long value) {
        return (1L & Math.abs(value)) == 1L;
    }

    public static boolean isPositive(double value) {
        return value > 0.0;
    }

    public static boolean isWhole(double value) {
        return Math.floor(value) == value;
    }

    public static boolean isWhole(Number value) {
        return value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof BigInteger;
    }

    public static boolean isZero(double value) {
        return value == 0.0;
    }

    public static boolean isByte(Number value) {
        return value instanceof Byte || NumberUtils.isWhole(value) && value.longValue() >= -128L && value.longValue() <= 127L;
    }

    public static boolean isShort(Number value) {
        return value instanceof Short || NumberUtils.isWhole(value) && value.longValue() >= -32768L && value.longValue() <= 32767L;
    }

    public static boolean isInteger(Number value) {
        return value instanceof Integer || NumberUtils.isWhole(value) && value.longValue() >= Integer.MIN_VALUE && value.longValue() <= Integer.MAX_VALUE;
    }

    public static boolean isLong(Number value) {
        return value instanceof Long;
    }

    public static boolean isFloat(Number value) {
        return value instanceof Float || NumberUtils.isDecimal(value) && value.doubleValue() >= (double)1.4E-45f && value.doubleValue() <= 3.4028234663852886E38;
    }

    public static boolean isDouble(Number value) {
        return value instanceof Double;
    }

    public static byte byteValue(Number number) {
        return number != null ? number.byteValue() : (byte)0;
    }

    public static short shortValue(Number number) {
        return number != null ? number.shortValue() : (short)0;
    }

    public static int intValue(Number number) {
        return number != null ? number.intValue() : 0;
    }

    public static long longValue(Number number) {
        return number != null ? number.longValue() : 0L;
    }

    public static float floatValue(Number number) {
        return number != null ? number.floatValue() : 0.0f;
    }

    public static double doubleValue(Number number) {
        return number != null ? number.doubleValue() : 0.0;
    }

    public static byte valueOf(Byte value) {
        return NumberUtils.byteValue(value);
    }

    public static short valueOf(Short value) {
        return NumberUtils.shortValue(value);
    }

    public static int valueOf(Integer value) {
        return NumberUtils.intValue(value);
    }

    public static long valueOf(Long value) {
        return NumberUtils.longValue(value);
    }

    public static float valueOf(Float value) {
        return NumberUtils.floatValue(value);
    }

    public static double valueOf(Double value) {
        return NumberUtils.doubleValue(value);
    }
}

