/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang;

import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.function.Supplier;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.CloneException;
import org.cp.elements.lang.RuntimeExceptionsFactory;
import org.cp.elements.lang.reflect.ConstructorNotFoundException;
import org.cp.elements.lang.reflect.ReflectionUtils;
import org.cp.elements.util.ArrayUtils;

public abstract class ObjectUtils
extends ReflectionUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static boolean areAllNull(Object ... values) {
        for (Object value : ArrayUtils.nullSafeArray(values)) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    public static boolean areAnyNull(Object ... values) {
        for (Object value : ArrayUtils.nullSafeArray(values)) {
            if (value != null) continue;
            return true;
        }
        return false;
    }

    public static <T> T clone(T obj) {
        if (obj instanceof Cloneable) {
            return (T)ObjectUtils.invoke(obj, "clone", obj.getClass());
        }
        if (obj != null) {
            try {
                Class<?> objectType = obj.getClass();
                Constructor<?> copyConstructor = ObjectUtils.resolveConstructor(objectType, new Class[]{objectType}, obj);
                return (T)copyConstructor.newInstance(obj);
            }
            catch (ConstructorNotFoundException objectType) {
            }
            catch (Exception e) {
                throw new CloneException("'clone' using 'copy constructor' was unsuccessful", e);
            }
        }
        throw new UnsupportedOperationException(new CloneNotSupportedException(String.format("'clone' is not supported for object of type [%s]", ObjectUtils.getClassSimpleName(obj))));
    }

    public static <T> T defaultIfNull(T ... values) {
        for (T value : ArrayUtils.nullSafeArray(values)) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static <T> T returnValueOrDefaultIfNull(T value, T defaultValue) {
        return (T)ObjectUtils.returnValueOrDefaultIfNull(value, () -> defaultValue);
    }

    public static <T> T returnValueOrDefaultIfNull(T value, Supplier<T> supplier) {
        return Optional.ofNullable(value).orElseGet(supplier);
    }

    public static <T> T returnValueOrThrowIfNull(T value) {
        return ObjectUtils.returnValueOrThrowIfNull(value, RuntimeExceptionsFactory.newIllegalArgumentException("Value must not be null", new Object[0]));
    }

    public static <T> T returnValueOrThrowIfNull(T value, RuntimeException exception) {
        Assert.notNull(exception, "RuntimeException must not be null", new Object[0]);
        return Optional.ofNullable(value).orElseThrow(() -> exception);
    }

    public static <T> T safeGetValue(Supplier<T> supplier) {
        return ObjectUtils.safeGetValue(supplier, null);
    }

    public static <T> T safeGetValue(Supplier<T> supplier, T defaultValue) {
        try {
            return supplier.get();
        }
        catch (Throwable ignore) {
            return defaultValue;
        }
    }

    public static boolean isNullOrEqualTo(Object obj1, Object obj2) {
        return obj1 == null || obj1.equals(obj2);
    }

    public static boolean equals(Object obj1, Object obj2) {
        return obj1 != null && obj1.equals(obj2);
    }

    public static boolean equalsIgnoreNull(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public static int hashCode(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    public static String toString(Object obj) {
        return obj != null ? obj.toString() : null;
    }
}

