/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang;

import org.cp.elements.lang.Assert;
import org.cp.elements.lang.LogicalOperator;
import org.cp.elements.lang.StringUtils;

public abstract class RelationalOperator<T extends Comparable<T>> {
    public static <T extends Comparable<T>> RelationalOperator<T> equalTo(T value) {
        return new EqualToOperator<T>(value);
    }

    public static <T extends Comparable<T>> RelationalOperator<T> greaterThan(T lowerBound) {
        return new GreaterThanOperator<T>(lowerBound);
    }

    public static <T extends Comparable<T>> RelationalOperator<T> greaterThanAndLessThan(T lowerBound, T upperBound) {
        return ComposableRelationalOperator.compose(RelationalOperator.greaterThan(lowerBound), LogicalOperator.AND, RelationalOperator.lessThan(upperBound));
    }

    public static <T extends Comparable<T>> RelationalOperator<T> greaterThanAndLessThanEqualTo(T lowerBound, T upperBound) {
        return ComposableRelationalOperator.compose(RelationalOperator.greaterThan(lowerBound), LogicalOperator.AND, RelationalOperator.lessThanEqualTo(upperBound));
    }

    public static <T extends Comparable<T>> RelationalOperator<T> greaterThanEqualTo(T lowerBound) {
        return new GreaterThanEqualToOperator<T>(lowerBound);
    }

    public static <T extends Comparable<T>> RelationalOperator<T> greaterThanEqualToAndLessThan(T lowerBound, T upperBound) {
        return ComposableRelationalOperator.compose(RelationalOperator.greaterThanEqualTo(lowerBound), LogicalOperator.AND, RelationalOperator.lessThan(upperBound));
    }

    public static <T extends Comparable<T>> RelationalOperator<T> greaterThanEqualToAndLessThanEqualTo(T lowerBound, T upperBound) {
        return ComposableRelationalOperator.compose(RelationalOperator.greaterThanEqualTo(lowerBound), LogicalOperator.AND, RelationalOperator.lessThanEqualTo(upperBound));
    }

    public static <T extends Comparable<T>> RelationalOperator<T> lessThan(T lowerBound) {
        return new LessThanOperator<T>(lowerBound);
    }

    public static <T extends Comparable<T>> RelationalOperator<T> lessThanOrGreaterThan(T lowerBound, T upperBound) {
        return ComposableRelationalOperator.compose(RelationalOperator.lessThan(lowerBound), LogicalOperator.OR, RelationalOperator.greaterThan(upperBound));
    }

    public static <T extends Comparable<T>> RelationalOperator<T> lessThanOrGreaterThanEqualTo(T lowerBound, T upperBound) {
        return ComposableRelationalOperator.compose(RelationalOperator.lessThan(lowerBound), LogicalOperator.OR, RelationalOperator.greaterThanEqualTo(upperBound));
    }

    public static <T extends Comparable<T>> RelationalOperator<T> lessThanEqualTo(T lowerBound) {
        return new LessThanEqualToOperator<T>(lowerBound);
    }

    public static <T extends Comparable<T>> RelationalOperator<T> lessThanEqualToOrGreaterThan(T lowerBound, T upperBound) {
        return ComposableRelationalOperator.compose(RelationalOperator.lessThanEqualTo(lowerBound), LogicalOperator.OR, RelationalOperator.greaterThan(upperBound));
    }

    public static <T extends Comparable<T>> RelationalOperator<T> lessThanEqualToOrGreaterThanEqualTo(T lowerBound, T upperBound) {
        return ComposableRelationalOperator.compose(RelationalOperator.lessThanEqualTo(lowerBound), LogicalOperator.OR, RelationalOperator.greaterThanEqualTo(upperBound));
    }

    public abstract String getDescription();

    public abstract String getSymbol();

    public abstract boolean evaluate(T var1);

    public String toString() {
        return this.getDescription();
    }

    private static final class LessThanEqualToOperator<T extends Comparable<T>>
    extends AbstractRelationalOperator<T> {
        public LessThanEqualToOperator(T expectedValue) {
            super("less than equal to", "<=", expectedValue);
        }

        @Override
        public boolean evaluate(T actualValue) {
            this.validate(actualValue);
            return actualValue.compareTo(this.getExpectedValue()) <= 0;
        }
    }

    private static final class LessThanOperator<T extends Comparable<T>>
    extends AbstractRelationalOperator<T> {
        public LessThanOperator(T expectedValue) {
            super("less than", "<", expectedValue);
        }

        @Override
        public boolean evaluate(T actualValue) {
            this.validate(actualValue);
            return actualValue.compareTo(this.getExpectedValue()) < 0;
        }
    }

    private static final class GreaterThanEqualToOperator<T extends Comparable<T>>
    extends AbstractRelationalOperator<T> {
        public GreaterThanEqualToOperator(T expectedValue) {
            super("greater than equal to", ">=", expectedValue);
        }

        @Override
        public boolean evaluate(T actualValue) {
            this.validate(actualValue);
            return actualValue.compareTo(this.getExpectedValue()) >= 0;
        }
    }

    private static final class GreaterThanOperator<T extends Comparable<T>>
    extends AbstractRelationalOperator<T> {
        public GreaterThanOperator(T expectedValue) {
            super("greater than", ">", expectedValue);
        }

        @Override
        public boolean evaluate(T actualValue) {
            this.validate(actualValue);
            return actualValue.compareTo(this.getExpectedValue()) > 0;
        }
    }

    private static final class EqualToOperator<T extends Comparable<T>>
    extends AbstractRelationalOperator<T> {
        public EqualToOperator(T expectedValue) {
            super("equal to", "==", expectedValue);
        }

        @Override
        public boolean evaluate(T actualValue) {
            this.validate(actualValue);
            return actualValue.equals(this.getExpectedValue());
        }
    }

    protected static final class ComposableRelationalOperator<T extends Comparable<T>>
    extends AbstractRelationalOperator<T> {
        private final LogicalOperator operator;
        private final RelationalOperator<T> leftOperand;
        private final RelationalOperator<T> rightOperand;

        private ComposableRelationalOperator(RelationalOperator<T> leftOperand, LogicalOperator operator, RelationalOperator<T> rightOperand) {
            super(StringUtils.singleSpaceObjects(leftOperand, operator, rightOperand), StringUtils.singleSpaceObjects(leftOperand.getSymbol(), operator.getSymbol(), rightOperand.getSymbol()));
            this.leftOperand = leftOperand;
            this.operator = operator;
            this.rightOperand = rightOperand;
        }

        public static <T extends Comparable<T>> RelationalOperator<T> compose(RelationalOperator<T> leftOperand, LogicalOperator operator, RelationalOperator<T> rightOperand) {
            return leftOperand == null ? rightOperand : (rightOperand == null ? leftOperand : new ComposableRelationalOperator<T>(leftOperand, operator, rightOperand));
        }

        protected RelationalOperator<T> getLeftOperand() {
            return this.leftOperand;
        }

        protected LogicalOperator getOperator() {
            return this.operator;
        }

        protected RelationalOperator<T> getRightOperand() {
            return this.rightOperand;
        }

        @Override
        public boolean evaluate(T actualValue) {
            return this.getOperator().evaluate(this.getLeftOperand().evaluate(actualValue), this.getRightOperand().evaluate(actualValue));
        }
    }

    protected static abstract class AbstractRelationalOperator<T extends Comparable<T>>
    extends RelationalOperator<T> {
        private final String description;
        private final String symbol;
        private final T expectedValue;

        private AbstractRelationalOperator(String description, String symbol) {
            Assert.hasText(description, "The description of the relational operator must be specified!", new Object[0]);
            Assert.hasText(symbol, "The symbol of the relation operator must be specified!", new Object[0]);
            this.description = description;
            this.symbol = symbol;
            this.expectedValue = null;
        }

        protected AbstractRelationalOperator(String description, String symbol, T expectedValue) {
            Assert.hasText(description, "The description of the relational operator must be specified!", new Object[0]);
            Assert.hasText(symbol, "The symbol of the relation operator must be specified!", new Object[0]);
            Assert.notNull(expectedValue, "The expected value in the {0} comparison cannot be null!", description);
            this.description = description;
            this.symbol = symbol;
            this.expectedValue = expectedValue;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        protected final T getExpectedValue() {
            return this.expectedValue;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }

        protected void validate(T actualValue) {
            Assert.notNull(actualValue, "The actual value in the {0} comparison cannot be null!", this.description);
        }
    }
}

