/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang;

import java.util.Optional;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.concurrent.ThreadUtils;

public abstract class RunnableUtils {
    public static boolean runWithSleep(long milliseconds, Runnable runnable) {
        Assert.isTrue(milliseconds > 0L, "Milliseconds [%d] must be greater than 0", milliseconds);
        runnable.run();
        return ThreadUtils.sleep(milliseconds, 0);
    }

    public static boolean runWithSleepThrowOnInterrupt(long milliseconds, Runnable runnable) {
        Assert.isTrue(milliseconds > 0L, "Milliseconds [%d] must be greater than 0", milliseconds);
        runnable.run();
        if (!ThreadUtils.sleep(milliseconds, 0)) {
            throw new SleepDeprivedException(String.format("Failed to wait for [%d] millisecond(s)", milliseconds));
        }
        return true;
    }

    public static boolean runWithSleepUninterrupted(long milliseconds, Runnable runnable) {
        Assert.isTrue(milliseconds > 0L, "Milliseconds [%d] must be greater than 0", milliseconds);
        runnable.run();
        return RunnableUtils.safeSleep(milliseconds);
    }

    public static <T> T runWithSleepThenReturnValue(long milliseconds, ReturningRunnable<T> runnable) {
        Assert.isTrue(milliseconds > 0L, "Milliseconds [%d] must be greater than 0", milliseconds);
        T returnValue = runnable.run();
        ThreadUtils.sleep(milliseconds, 0);
        return returnValue;
    }

    public static <T> T runWithSleepThenReturnValueThrowOnInterrupt(long milliseconds, ReturningRunnable<T> runnable) {
        Assert.isTrue(milliseconds > 0L, "Milliseconds [%d] must be greater than 0", milliseconds);
        T returnValue = runnable.run();
        if (!ThreadUtils.sleep(milliseconds, 0)) {
            throw new SleepDeprivedException(String.format("Failed to wait for [%d] millisecond(s)", milliseconds));
        }
        return returnValue;
    }

    public static <T> T runWithSleepThenReturnValueUninterrupted(long milliseconds, ReturningRunnable<T> runnable) {
        Assert.isTrue(milliseconds > 0L, "Milliseconds [%d] must be greater than 0", milliseconds);
        T returnValue = runnable.run();
        RunnableUtils.safeSleep(milliseconds);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean safeSleep(long milliseconds) {
        boolean interrupted = false;
        long timeout = System.currentTimeMillis() + milliseconds;
        while (System.currentTimeMillis() < timeout) {
            try {
                Thread.sleep(milliseconds);
            }
            catch (InterruptedException cause) {
                interrupted = true;
            }
            finally {
                milliseconds = Math.min(timeout - System.currentTimeMillis(), 0L);
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return !Thread.currentThread().isInterrupted();
    }

    public static Optional<Long> timedRun(Runnable runnable) {
        long t0 = System.currentTimeMillis();
        runnable.run();
        return Optional.of(System.currentTimeMillis() - t0);
    }

    public static final class SleepDeprivedException
    extends RuntimeException {
        public SleepDeprivedException() {
        }

        public SleepDeprivedException(String message) {
            super(message);
        }

        public SleepDeprivedException(Throwable cause) {
            super(cause);
        }

        public SleepDeprivedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @FunctionalInterface
    public static interface ReturningRunnable<T> {
        public T run();
    }
}

