/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.LangExtensions;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.util.ArrayUtils;

public abstract class StringUtils {
    public static final char COMMA_DELIMITER_CHAR = ',';
    public static final char DOT_SEPARATOR_CHAR = '.';
    public static final char EMPTY_CHAR = '\u0000';
    public static final char SINGLE_SPACE_CHAR = ' ';
    public static final String COMMA_DELIMITER = ",";
    public static final String COMMA_SPACE_DELIMITER = ", ";
    public static final String DOT_SEPARATOR = ".";
    public static final String EMPTY_STRING = "";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String SINGLE_SPACE = " ";
    public static final String UTF_8 = "UTF-8";
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String[] SPACES = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          "};

    public static String capitalize(String value) {
        Assert.hasText(value, "Value [%s] is required", value);
        String firstCharacter = String.valueOf(value.charAt(0));
        return firstCharacter.toUpperCase().concat(value.substring(1));
    }

    public static String concat(String ... values) {
        return StringUtils.concat(values, COMMA_SPACE_DELIMITER);
    }

    public static String concat(String[] values, String delimiter) {
        Assert.notNull(values, "The array of String values to concatenate cannot be null!", new Object[0]);
        StringBuilder buffer = new StringBuilder();
        for (String value : values) {
            buffer.append(buffer.length() > 0 ? delimiter : EMPTY_STRING);
            buffer.append(value);
        }
        return buffer.toString();
    }

    public static boolean contains(String text, String value) {
        return text != null && value != null && text.contains(value);
    }

    public static boolean containsDigits(String value) {
        for (char chr : StringUtils.toCharArray(value)) {
            if (!Character.isDigit(chr)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsLetters(String value) {
        for (char chr : StringUtils.toCharArray(value)) {
            if (!Character.isLetter(chr)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(String value) {
        for (char chr : StringUtils.toCharArray(value)) {
            if (!Character.isWhitespace(chr)) continue;
            return true;
        }
        return false;
    }

    public static String defaultIfBlank(String value, String ... defaultValues) {
        if (StringUtils.isBlank(value)) {
            for (String defaultValue : defaultValues) {
                if (!StringUtils.hasText(defaultValue)) continue;
                return defaultValue;
            }
        }
        return value;
    }

    public static boolean equalsIgnoreCase(String stringOne, String stringTwo) {
        return stringOne != null && stringOne.equalsIgnoreCase(stringTwo);
    }

    public static String getDigits(String value) {
        StringBuilder digits = new StringBuilder(value.length());
        for (char chr : value.toCharArray()) {
            if (!Character.isDigit(chr)) continue;
            digits.append(chr);
        }
        return digits.toString();
    }

    public static String getLetters(String value) {
        StringBuilder letters = new StringBuilder(value.length());
        for (char chr : value.toCharArray()) {
            if (!Character.isLetter(chr)) continue;
            letters.append(chr);
        }
        return letters.toString();
    }

    public static String getSpaces(int number) {
        Assert.argument(number >= 0, "The number [{0}] of desired spaces must be greater than equal to 0", number);
        StringBuilder spaces = new StringBuilder(Math.max(number, 0));
        while (number > 0) {
            int count = Math.min(SPACES.length - 1, number);
            spaces.append(SPACES[count]);
            number -= count;
        }
        return spaces.toString();
    }

    public static boolean hasText(String value) {
        return !StringUtils.isBlank(value);
    }

    public static int indexOf(String text, String value) {
        return text != null && value != null ? text.indexOf(value) : -1;
    }

    public static boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static boolean isDigits(String value) {
        for (char chr : StringUtils.toCharArray(value)) {
            if (Character.isDigit(chr)) continue;
            return false;
        }
        return StringUtils.hasText(value);
    }

    public static boolean isEmpty(String value) {
        return EMPTY_STRING.equals(value);
    }

    public static boolean isLetters(String value) {
        for (char chr : StringUtils.toCharArray(value)) {
            if (Character.isLetter(chr)) continue;
            return false;
        }
        return StringUtils.hasText(value);
    }

    public static int lastIndexOf(String text, String value) {
        return text != null && value != null ? text.lastIndexOf(value) : -1;
    }

    public static int length(String value) {
        return value != null ? value.length() : 0;
    }

    public static String pad(String value, int length) {
        return StringUtils.pad(value, ' ', length);
    }

    public static String pad(String value, char padding, int length) {
        LangExtensions.assertThat(length).throwing(new IllegalArgumentException(String.format("[%d] must be greater than equal to 0", length))).isGreaterThanEqualTo(0);
        if (length > 0) {
            StringBuilder builder = new StringBuilder(ObjectUtils.defaultIfNull(value, EMPTY_STRING));
            while (length - builder.length() > 0) {
                builder.append(padding);
            }
            return builder.toString();
        }
        return value;
    }

    public static String replaceAll(String value, String pattern, String replacement) {
        if (!ObjectUtils.areAnyNull(value, pattern, replacement)) {
            value = Pattern.compile(pattern).matcher(value).replaceAll(replacement);
        }
        return value;
    }

    public static String singleSpaceObjects(Object ... values) {
        ArrayList<String> valueList = new ArrayList<String>(values.length);
        for (Object value : values) {
            valueList.add(String.valueOf(value));
        }
        return StringUtils.trim(StringUtils.concat(valueList.toArray(new String[valueList.size()]), SINGLE_SPACE));
    }

    public static String singleSpaceString(String value) {
        Assert.hasText(value, "String value must contain text", new Object[0]);
        return StringUtils.trim(StringUtils.concat(value.split("\\s+"), SINGLE_SPACE));
    }

    public static char[] toCharArray(String value) {
        return value != null ? value.toCharArray() : EMPTY_CHAR_ARRAY;
    }

    public static String toLowerCase(String value) {
        return value != null ? value.toLowerCase() : null;
    }

    public static String[] toStringArray(String commaDelimitedValue) {
        return StringUtils.toStringArray(commaDelimitedValue, COMMA_DELIMITER);
    }

    public static String[] toStringArray(String delimitedValue, String delimiter) {
        return ArrayUtils.transform(ObjectUtils.defaultIfNull(delimitedValue, EMPTY_STRING).split(StringUtils.defaultIfBlank(delimiter, COMMA_DELIMITER)), StringUtils::trim);
    }

    public static String toUpperCase(String value) {
        return value != null ? value.toUpperCase() : null;
    }

    public static String trim(String value) {
        return value != null ? value.trim() : null;
    }

    public static String trimAll(String value) {
        if (value != null) {
            StringBuilder trimmedValue = new StringBuilder(value.length());
            for (char chr : value.toCharArray()) {
                if (Character.isWhitespace(chr)) continue;
                trimmedValue.append(chr);
            }
            return trimmedValue.toString();
        }
        return null;
    }

    public static String truncate(String value, int length) {
        LangExtensions.assertThat(length).throwing(new IllegalArgumentException(String.format("[%d] must be greater than equal to 0", length))).isGreaterThanEqualTo(0);
        return value != null ? value.substring(0, Math.min(value.length(), length)) : null;
    }

    public static String wrap(String line, int widthInCharacters, String indent) {
        StringBuilder buffer = new StringBuilder();
        int lineCount = 1;
        String string = indent = indent != null ? indent : EMPTY_STRING;
        while (line.length() > widthInCharacters) {
            int spaceIndex = line.substring(0, widthInCharacters).lastIndexOf(SINGLE_SPACE);
            buffer.append(lineCount++ > 1 ? indent : EMPTY_STRING);
            buffer.append(line.substring(0, spaceIndex));
            buffer.append(LINE_SEPARATOR);
            line = line.substring(spaceIndex + 1);
        }
        buffer.append(lineCount > 1 ? indent : EMPTY_STRING);
        buffer.append(line);
        return buffer.toString();
    }
}

