/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang;

import java.util.Scanner;
import org.cp.elements.lang.StringUtils;

public abstract class SystemUtils {
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String IBM_J9_JVM_NAME = "J9";
    public static final String ORACLE_HOTSPOT_JVM_NAME = "HotSpot";
    public static final String ORACLE_JROCKIT_JVM_NAME = "JRockit";
    public static final String APPLE_JVM_VENDOR = "Apple";
    public static final String IBM_JVM_VENDOR = "IBM";
    public static final String ORACLE_JVM_VENDOR = "Oracle";
    public static final String LINUX_OS_NAME = "Linux";
    public static final String MAC_OSX_NAME = "Mac";
    public static final String WINDOWS_OS_NAME = "Windows";
    public static final String MAC_OSX_VENDOR = "Apple";
    public static final String RED_HAT_LINUX_OS_VENDOR = "Red Hat";
    public static final String SUSE_LINUX_OS_VENDOR = "Suse";
    public static final String UBUNTU_LINUX_OS_VENDOR = "Canonical";
    public static final String WINDOWS_OS_VENDOR = "Microsoft";
    public static final String JAVA_HOME = System.getProperty("java.home");
    public static final String TEMPORARY_DIRECTORY = System.getProperty("java.io.tmpdir");
    public static final String USER_DIRECTORY = System.getProperty("user.dir");
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String USERNAME = System.getProperty("user.name");

    public static boolean isJavaVersionAtLeast(String expectedVersion) {
        String actualVersionDigits = StringUtils.getDigits(System.getProperty("java.version"));
        String expectedVersionDigits = StringUtils.pad(StringUtils.getDigits(expectedVersion), '0', actualVersionDigits.length());
        try {
            return Long.parseLong(actualVersionDigits) >= Long.parseLong(expectedVersionDigits);
        }
        catch (NumberFormatException ignore) {
            return false;
        }
    }

    public static boolean isAppleJvm() {
        return SystemUtils.isJvmMake("Apple");
    }

    public static boolean isIbmJvm() {
        return SystemUtils.isJvmMake(IBM_JVM_VENDOR);
    }

    public static boolean isOracleJvm() {
        return SystemUtils.isJvmMake(ORACLE_JVM_VENDOR);
    }

    protected static boolean isJvmMake(String expectedJvmVendor) {
        return StringUtils.contains(System.getProperty("java.vm.vendor"), expectedJvmVendor);
    }

    public static boolean isHotSpotJvm() {
        return SystemUtils.isJvmModel(ORACLE_HOTSPOT_JVM_NAME);
    }

    public static boolean isJ9Jvm() {
        return SystemUtils.isJvmModel(IBM_J9_JVM_NAME);
    }

    public static boolean isJRockitJvm() {
        return SystemUtils.isJvmModel(ORACLE_JROCKIT_JVM_NAME);
    }

    protected static boolean isJvmModel(String expectedJvmName) {
        return StringUtils.contains(System.getProperty("java.vm.name"), expectedJvmName);
    }

    public static boolean isLinux() {
        return SystemUtils.isOS(LINUX_OS_NAME);
    }

    public static boolean isMacOSX() {
        return SystemUtils.isOS(MAC_OSX_NAME);
    }

    public static boolean isWindows() {
        return SystemUtils.isOS(WINDOWS_OS_NAME);
    }

    public static boolean isUnixBasedOperatingSystem() {
        return SystemUtils.isLinux() || SystemUtils.isMacOSX();
    }

    protected static boolean isOS(String expectedOsName) {
        return StringUtils.contains(System.getProperty("os.name"), expectedOsName);
    }

    public static void promptPressEnterToExit() {
        System.err.println("Press <enter> to exit...");
        new Scanner(System.in).nextLine();
    }
}

