/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.util.ComparatorUtils;

public class ValueHolder<T> {
    private T value;

    public static <T extends Comparable<T>> ComparableValueHolder<T> withComparableValue(T value) {
        return new ComparableValueHolder<T>(value);
    }

    public static <T extends Cloneable> ValueHolder<T> withImmutableValue(T value) {
        return new ValueHolder<T>(ObjectUtils.clone(value)){

            @Override
            public T getValue() {
                return (Cloneable)ObjectUtils.clone(super.getValue());
            }

            @Override
            public void setValue(T value) {
                super.setValue(ObjectUtils.clone(value));
            }
        };
    }

    public static <T> ValueHolder<T> withNonNullValue(T value) {
        Assert.notNull(value, "The value must not be null!", new Object[0]);
        return new ValueHolder<T>((Object)value){

            @Override
            public void setValue(T value) {
                Assert.notNull(value, "The value must not be null!", new Object[0]);
                super.setValue(value);
            }
        };
    }

    public static <T extends Serializable> SerializableValueHolder<T> withSerializableValue(T value) {
        return new SerializableValueHolder<T>(value);
    }

    public ValueHolder() {
    }

    public ValueHolder(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValueHolder)) {
            return false;
        }
        ValueHolder that = (ValueHolder)obj;
        return ObjectUtils.equalsIgnoreNull(this.getValue(), that.getValue());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getValue());
        return hashValue;
    }

    public String toString() {
        return String.valueOf(this.getValue());
    }

    public static class SerializableValueHolder<T extends Serializable>
    extends ValueHolder<T>
    implements Serializable {
        private static final long serialVersionUID = 421081248L;

        public SerializableValueHolder() {
        }

        public SerializableValueHolder(T value) {
            super(value);
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            this.setValue((Serializable)in.readObject());
        }

        private void readObjectNoData() throws ObjectStreamException {
            this.setValue(null);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.getValue());
        }
    }

    public static class ComparableValueHolder<T extends Comparable<T>>
    extends ValueHolder<T>
    implements Comparable<T> {
        public ComparableValueHolder() {
        }

        public ComparableValueHolder(T value) {
            super(value);
        }

        @Override
        public int compareTo(T value) {
            return ComparatorUtils.compareIgnoreNull((Comparable)this.getValue(), value);
        }
    }
}

