/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.concurrent;

import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.IdentifierSequence;
import org.cp.elements.lang.ThrowableUtils;
import org.cp.elements.lang.support.UUIDIdentifierSequence;

public class SimpleThreadFactory
implements ThreadFactory {
    protected static final boolean DEFAULT_DAEMON = true;
    protected static final Logger logger = Logger.getLogger(SimpleThreadFactory.class.getName());
    protected static final ThreadGroup DEFAULT_THREAD_GROUP = new ThreadGroup(String.format("%s.THREAD-GROUP", SimpleThreadFactory.class.getName()));
    private Boolean daemon = true;
    private ClassLoader contextClassLoader;
    private final IdentifierSequence<String> threadIdGenerator = new UUIDIdentifierSequence();
    private Integer priority;
    private ThreadGroup threadGroup;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public static SimpleThreadFactory newThreadFactory() {
        return new SimpleThreadFactory();
    }

    protected String generatedThreadId() {
        return this.threadIdGenerator.nextId();
    }

    protected String generateThreadName() {
        return String.format("%1$s.THREAD-%2$s", SimpleThreadFactory.class.getName(), this.generatedThreadId());
    }

    @Override
    public Thread newThread(Runnable task) {
        return this.newThread(this.generateThreadName(), task);
    }

    public Thread newThread(String name, Runnable task) {
        Assert.hasText(name, "Thread name must be specified", new Object[0]);
        Assert.notNull(task, "Thread task must not be null", new Object[0]);
        Thread thread = new Thread(this.getThreadGroup(), task, name);
        thread.setContextClassLoader(this.getContextClassLoader());
        thread.setDaemon(this.isDaemon());
        thread.setPriority(this.getPriority());
        thread.setUncaughtExceptionHandler(this.getUncaughtExceptionHandler());
        return thread;
    }

    public ClassLoader getContextClassLoader() {
        return Optional.ofNullable(this.contextClassLoader).orElseGet(() -> Thread.currentThread().getContextClassLoader());
    }

    public boolean isDaemon() {
        return Boolean.TRUE.equals(this.daemon);
    }

    public int getPriority() {
        return Optional.ofNullable(this.priority).orElse(5);
    }

    public ThreadGroup getThreadGroup() {
        return Optional.ofNullable(this.threadGroup).orElse(DEFAULT_THREAD_GROUP);
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return Optional.ofNullable(this.uncaughtExceptionHandler).orElse(SimpleUncaughtExceptionHandler.INSTANCE);
    }

    public SimpleThreadFactory as(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public SimpleThreadFactory in(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
        return this;
    }

    public SimpleThreadFactory using(ClassLoader contextClassLoader) {
        this.contextClassLoader = contextClassLoader;
        return this;
    }

    public SimpleThreadFactory using(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    public SimpleThreadFactory with(int priority) {
        this.priority = priority;
        return this;
    }

    protected static class SimpleUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        protected static final SimpleUncaughtExceptionHandler INSTANCE = new SimpleUncaughtExceptionHandler();

        protected SimpleUncaughtExceptionHandler() {
        }

        protected Logger getLogger() {
            return logger;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable cause) {
            this.getLogger().warning(String.format("An unhandled error [%1$s] was thrown by Thread [%2$s] having ID [%3$d]", cause.getClass().getName(), thread.getName(), thread.getId()));
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine(ThrowableUtils.getStackTrace(cause));
            }
        }
    }
}

