/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.concurrent;

import org.cp.elements.lang.LangExtensions;
import org.cp.elements.lang.RuntimeExceptionsFactory;

public class ThreadAdapter {
    private final Thread delegate;

    public ThreadAdapter() {
        this(Thread.currentThread());
    }

    public ThreadAdapter(Runnable target) {
        this(new Thread(target));
    }

    public ThreadAdapter(Thread delegate) {
        LangExtensions.assertThat(delegate).throwing(RuntimeExceptionsFactory.newIllegalArgumentException("The delegate Thread must not be null", new Object[0])).isNotNull();
        this.delegate = delegate;
    }

    protected Thread getDelegate() {
        return this.delegate;
    }

    public boolean isAlive() {
        return this.getDelegate().isAlive();
    }

    public boolean isBlocked() {
        return Thread.State.BLOCKED.equals((Object)this.getState());
    }

    public boolean isDaemon() {
        return this.getDelegate().isDaemon();
    }

    public boolean isNonDaemon() {
        return !this.isDaemon();
    }

    public boolean isInterrupted() {
        return this.getDelegate().isInterrupted();
    }

    public boolean isNew() {
        return Thread.State.NEW.equals((Object)this.getState());
    }

    public boolean isRunnable() {
        return Thread.State.RUNNABLE.equals((Object)this.getState());
    }

    public boolean isTerminated() {
        return Thread.State.TERMINATED.equals((Object)this.getState());
    }

    public boolean isTimedWaiting() {
        return Thread.State.TIMED_WAITING.equals((Object)this.getState());
    }

    public boolean isWaiting() {
        return Thread.State.WAITING.equals((Object)this.getState());
    }

    public ThreadAdapter setContextClassLoader(ClassLoader contextClassLoader) {
        this.getDelegate().setContextClassLoader(contextClassLoader);
        return this;
    }

    public ClassLoader getContextClassLoader() {
        return this.getDelegate().getContextClassLoader();
    }

    public ThreadAdapter setDaemon(boolean daemon) {
        this.getDelegate().setDaemon(daemon);
        return this;
    }

    public long getId() {
        return this.getDelegate().getId();
    }

    public ThreadAdapter setName(String name) {
        this.getDelegate().setName(name);
        return this;
    }

    public String getName() {
        return this.getDelegate().getName();
    }

    public ThreadAdapter setPriority(int priority) {
        this.getDelegate().setPriority(priority);
        return this;
    }

    public int getPriority() {
        return this.getDelegate().getPriority();
    }

    public StackTraceElement[] getStackTrace() {
        return this.getDelegate().getStackTrace();
    }

    public Thread.State getState() {
        return this.getDelegate().getState();
    }

    public ThreadGroup getThreadGroup() {
        return this.getDelegate().getThreadGroup();
    }

    public ThreadAdapter setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.getDelegate().setUncaughtExceptionHandler(uncaughtExceptionHandler);
        return this;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.getDelegate().getUncaughtExceptionHandler();
    }

    public void checkAccess() {
        this.getDelegate().checkAccess();
    }

    public void dumpStack() {
        Thread.dumpStack();
    }

    public void interrupt() {
        this.getDelegate().interrupt();
    }

    public void join() throws InterruptedException {
        this.getDelegate().join();
    }

    public void join(long milliseconds) throws InterruptedException {
        this.getDelegate().join(milliseconds);
    }

    public void join(long milliseconds, int nanoseconds) throws InterruptedException {
        this.getDelegate().join(milliseconds, nanoseconds);
    }

    public void run() {
        this.getDelegate().run();
    }

    public void start() {
        this.getDelegate().start();
    }

    public String toString() {
        return String.format("{ @type = %1$s, id = %2$d, name = %3$s, daemon = %4$s, group = %5$s, priority = %6$s, state = %7$s }", new Object[]{this.getClass().getName(), this.getId(), this.getName(), this.isDaemon(), this.getThreadGroup(), this.getPriority(), this.getState()});
    }
}

