/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.concurrent;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.Condition;
import org.cp.elements.lang.FluentApiExtension;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.lang.annotation.FluentApi;

public abstract class ThreadUtils {
    public static boolean isAlive(Thread thread) {
        return thread != null && thread.isAlive();
    }

    public static boolean isBlocked(Thread thread) {
        return thread != null && Thread.State.BLOCKED.equals((Object)thread.getState());
    }

    public static boolean isDaemon(Thread thread) {
        return thread != null && thread.isDaemon();
    }

    public static boolean isNonDaemon(Thread thread) {
        return thread != null && !thread.isDaemon();
    }

    public static boolean isInterrupted(Thread thread) {
        return thread != null && thread.isInterrupted();
    }

    public static boolean isNew(Thread thread) {
        return thread != null && Thread.State.NEW.equals((Object)thread.getState());
    }

    public static boolean isRunnable(Thread thread) {
        return thread != null && Thread.State.RUNNABLE.equals((Object)thread.getState());
    }

    public static boolean isTerminated(Thread thread) {
        return thread != null && Thread.State.TERMINATED.equals((Object)thread.getState());
    }

    public static boolean isTimedWaiting(Thread thread) {
        return thread != null && Thread.State.TIMED_WAITING.equals((Object)thread.getState());
    }

    public static boolean isWaiting(Thread thread) {
        return thread != null && Thread.State.WAITING.equals((Object)thread.getState());
    }

    public static ClassLoader getContextClassLoader(Thread thread) {
        return thread != null ? thread.getContextClassLoader() : ThreadUtils.class.getClassLoader();
    }

    public static long getId(Thread thread) {
        return thread != null ? thread.getId() : 0L;
    }

    public static String getName(Thread thread) {
        return thread != null ? thread.getName() : null;
    }

    public static int getPriority(Thread thread) {
        return thread != null ? thread.getPriority() : 0;
    }

    public static StackTraceElement[] getStackTrace(Thread thread) {
        return thread != null ? thread.getStackTrace() : new StackTraceElement[]{};
    }

    public static Thread.State getState(Thread thread) {
        return thread != null ? thread.getState() : null;
    }

    public static ThreadGroup getThreadGroup(Thread thread) {
        return thread != null ? thread.getThreadGroup() : null;
    }

    public static void dumpStack(String tag) {
        Thread currentThread = Thread.currentThread();
        System.err.printf("%1$s - %2$s Thread @ %3$d%n", String.valueOf(tag).toUpperCase(), currentThread.getName(), currentThread.getId());
        Thread.dumpStack();
    }

    public static void interrupt(Thread thread) {
        Optional.ofNullable(thread).ifPresent(Thread::interrupt);
    }

    public static boolean join(Thread thread, long milliseconds, int nanoseconds) {
        try {
            if (thread != null) {
                thread.join(milliseconds, nanoseconds);
                return true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public static boolean sleep(long milliseconds, int nanoseconds) {
        try {
            Thread.sleep(milliseconds, nanoseconds);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @FluentApi
    public static WaitTask waitFor(long duration) {
        return WaitTask.newWaitTask().waitFor(duration);
    }

    @FluentApi
    public static WaitTask waitFor(long duration, TimeUnit timeUnit) {
        return WaitTask.newWaitTask().waitFor(duration, timeUnit);
    }

    public static class WaitTask
    implements FluentApiExtension {
        protected static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
        private long duration;
        private long interval;
        private final Object waitTaskMonitor = new Object();
        private TimeUnit durationTimeUnit;
        private TimeUnit intervalTimeUnit;

        public static WaitTask newWaitTask() {
            return new WaitTask();
        }

        public long getDuration() {
            return this.duration;
        }

        public TimeUnit getDurationTimeUnit() {
            return this.durationTimeUnit;
        }

        public long getInterval() {
            long duration = this.getDuration();
            return this.interval > 0L ? Math.min(this.interval, duration) : duration;
        }

        public TimeUnit getIntervalTimeUnit() {
            return ObjectUtils.defaultIfNull(this.intervalTimeUnit, this.getDurationTimeUnit());
        }

        public WaitTask waitFor(long duration) {
            return this.waitFor(duration, DEFAULT_TIME_UNIT);
        }

        public WaitTask waitFor(long duration, TimeUnit durationTimeUnit) {
            Assert.argument(duration > 0L, String.format("duration (%1$d) must be greater than 0", duration), new Object[0]);
            this.duration = duration;
            this.durationTimeUnit = ObjectUtils.defaultIfNull(durationTimeUnit, DEFAULT_TIME_UNIT);
            return this;
        }

        private boolean isValidInterval(long interval, TimeUnit intervalTimeUnit) {
            return interval > 0L && intervalTimeUnit.toMillis(interval) <= this.getDurationTimeUnit().toMillis(this.getDuration());
        }

        public WaitTask checkEvery(long interval) {
            return this.checkEvery(interval, DEFAULT_TIME_UNIT);
        }

        public WaitTask checkEvery(long interval, TimeUnit intervalTimeUnit) {
            intervalTimeUnit = Optional.ofNullable(intervalTimeUnit).orElse(DEFAULT_TIME_UNIT);
            Assert.argument(this.isValidInterval(interval, intervalTimeUnit), String.format("Interval [%1$d %2$s] must be greater than 0 and less than equal to duration [%3$d %4$s]", new Object[]{interval, intervalTimeUnit, this.duration, this.durationTimeUnit}), new Object[0]);
            this.interval = interval;
            this.intervalTimeUnit = intervalTimeUnit;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean on(Condition condition) {
            long timeout = System.currentTimeMillis() + this.getDurationTimeUnit().toMillis(this.getDuration());
            long interval = this.getIntervalTimeUnit().toMillis(this.getInterval());
            condition = Optional.ofNullable(condition).orElse(Condition.FALSE_CONDITION);
            try {
                while (!condition.evaluate() && System.currentTimeMillis() < timeout) {
                    Object object = this.waitTaskMonitor;
                    synchronized (object) {
                        interval = Math.min(interval, timeout - System.currentTimeMillis());
                        TimeUnit.MILLISECONDS.timedWait(this.waitTaskMonitor, interval);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (Condition.FALSE_CONDITION.equals(condition)) return true;
            if (condition.evaluate()) return true;
            return false;
        }

        public boolean run() {
            return this.on(null);
        }
    }
}

