/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.factory;

import java.lang.reflect.Constructor;
import org.cp.elements.context.configure.Configuration;
import org.cp.elements.data.conversion.ConversionService;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ClassUtils;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.lang.factory.NoSuchConstructorException;
import org.cp.elements.lang.factory.ObjectFactory;
import org.cp.elements.lang.factory.ObjectInstantiationException;
import org.cp.elements.util.ArrayUtils;
import org.cp.elements.util.CollectionExtensions;

public abstract class AbstractObjectFactory
implements ObjectFactory {
    private volatile Configuration configuration;
    private volatile ConversionService conversionService;

    protected boolean isConfigurationAvailable() {
        return this.configuration != null;
    }

    protected Configuration getConfiguration() {
        Assert.state(this.configuration != null, "The Configuration was not properly initialized", new Object[0]);
        return this.configuration;
    }

    @Override
    public final void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected boolean isConversionServiceAvailable() {
        return this.conversionService != null;
    }

    protected ConversionService getConversionService() {
        Assert.state(this.conversionService != null, "The ConversionService was not properly initialized", new Object[0]);
        return this.conversionService;
    }

    @Override
    public final void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    protected Class[] getArgumentTypes(Object ... arguments) {
        Class[] argumentTypes = new Class[arguments.length];
        int index = 0;
        for (Object argument : arguments) {
            argumentTypes[index++] = ObjectUtils.defaultIfNull(ClassUtils.getClass(argument), Object.class);
        }
        return argumentTypes;
    }

    protected Constructor resolveConstructor(Class<?> objectType, Class ... parameterTypes) {
        try {
            return objectType.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (!ArrayUtils.isEmpty(parameterTypes)) {
                Constructor constructor = this.resolveCompatibleConstructor(objectType, parameterTypes);
                return constructor != null ? constructor : this.resolveConstructor(objectType, new Class[0]);
            }
            throw new NoSuchConstructorException(String.format("Failed to find a constructor with signature (%1$s) in Class (%2$s)", CollectionExtensions.from(parameterTypes).toString(), objectType.getName()), e);
        }
    }

    protected Constructor resolveCompatibleConstructor(Class<?> objectType, Class<?>[] parameterTypes) {
        for (Constructor<?> constructor : objectType.getConstructors()) {
            Class<?>[] constructorParameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != constructorParameterTypes.length) continue;
            boolean match = true;
            for (int index = 0; index < constructorParameterTypes.length; ++index) {
                match &= constructorParameterTypes[index].isAssignableFrom(parameterTypes[index]);
            }
            if (!match) continue;
            return constructor;
        }
        return null;
    }

    @Override
    public <T> T create(String objectTypeName, Object ... args) {
        return this.create(ClassUtils.loadClass(objectTypeName), this.getArgumentTypes(args), args);
    }

    @Override
    public <T> T create(String objectTypeName, Class[] parameterTypes, Object ... args) {
        return this.create(ClassUtils.loadClass(objectTypeName), parameterTypes, args);
    }

    @Override
    public <T> T create(Class<T> objectType, Object ... args) {
        return this.create(objectType, this.getArgumentTypes(args), args);
    }

    @Override
    public <T> T create(Class<T> objectType, Class[] parameterTypes, Object ... args) {
        try {
            T object;
            Constructor constructor = this.resolveConstructor(objectType, parameterTypes);
            if (!ArrayUtils.isEmpty(constructor.getParameterTypes())) {
                Assert.equals(ArrayUtils.nullSafeLength(constructor.getParameterTypes()), ArrayUtils.nullSafeLength(args), "The number of arguments ({0,number,integer}) does not match the number of parameters ({1,number,integer}) for constructor ({2}) in Class ({3})!", ArrayUtils.nullSafeLength(args), ArrayUtils.nullSafeLength(constructor.getParameterTypes()), constructor, objectType);
                object = this.postConstruct(objectType.cast(constructor.newInstance(args)), new Object[0]);
            } else {
                object = this.postConstruct(objectType.cast(constructor.newInstance(new Object[0])), args);
            }
            return object;
        }
        catch (Exception e) {
            throw new ObjectInstantiationException(String.format("Failed to instantiate and instance of class (%1$s) with constructor having signature (%2$s) using arguments (%3$s)!", ClassUtils.getName(objectType), CollectionExtensions.from(parameterTypes).toString(), CollectionExtensions.from(args).toString()), e);
        }
    }

    protected <T> T postConstruct(T object, Object ... args) {
        return object;
    }
}

