/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.factory;

import org.cp.elements.lang.Assert;
import org.cp.elements.lang.factory.ObjectFactory;

public final class ObjectFactoryReferenceHolder {
    private static ObjectFactory objectFactoryReference;

    public static synchronized boolean hasReference() {
        return objectFactoryReference != null;
    }

    public static synchronized ObjectFactory get() {
        Assert.state(objectFactoryReference != null, "ObjectFactory was not properly initialized!", new Object[0]);
        return objectFactoryReference;
    }

    public static synchronized void set(ObjectFactory objectFactory) {
        Assert.state(objectFactoryReference == null, "The ObjectFactory reference is already set to ({0})", objectFactoryReference);
        objectFactoryReference = objectFactory;
    }

    public static synchronized void compareAndSet(ObjectFactory currentObjectFactory, ObjectFactory objectFactory) {
        if (currentObjectFactory == objectFactoryReference) {
            objectFactoryReference = objectFactory;
        }
    }

    public static synchronized void clear() {
        objectFactoryReference = null;
    }
}

