/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ClassUtils;
import org.cp.elements.lang.LangExtensions;
import org.cp.elements.lang.RuntimeExceptionsFactory;
import org.cp.elements.lang.reflect.MethodInvocationException;
import org.cp.elements.lang.reflect.ModifierUtils;
import org.cp.elements.util.ArrayUtils;

public class MethodInvocation {
    private final Method method;
    private Object target;
    private Object[] arguments;

    public static MethodInvocation newMethodInvocation(Method method, Object ... args) {
        return MethodInvocation.newMethodInvocation(null, method, args);
    }

    public static MethodInvocation newMethodInvocation(Object target, Method method, Object ... args) {
        return new MethodInvocation(target, method, args);
    }

    public static MethodInvocation newMethodInvocation(Class<?> type, String methodName, Object ... args) {
        Assert.notNull(type, "Class type cannot be null", new Object[0]);
        return new MethodInvocation(null, ClassUtils.findMethod(type, methodName, args), args);
    }

    public static MethodInvocation newMethodInvocation(Object target, String methodName, Object ... args) {
        Assert.notNull(target, "Target object cannot be null", new Object[0]);
        return new MethodInvocation(target, ClassUtils.findMethod(target.getClass(), methodName, args), args);
    }

    public MethodInvocation(Object target, Method method, Object ... args) {
        Assert.notNull(method, "Method cannot be null", new Object[0]);
        Assert.isTrue(target != null || ModifierUtils.isStatic(method), "Method must be static if target is null", new Object[0]);
        this.arguments = this.validateArguments(method, args);
        this.method = method;
        this.target = target;
    }

    protected Object[] validateArguments(Method method, Object ... args) {
        Assert.notNull(method, "Method cannot be null", new Object[0]);
        Object[] arguments = ArrayUtils.nullSafeArray(args);
        int methodParameterCount = method.getParameterCount();
        LangExtensions.assertThat(arguments.length).throwing(RuntimeExceptionsFactory.newIllegalArgumentException("The number of arguments [%1$d] does not match the number of parameters [%2$d] for method [%3$s] in class [%4$s]", arguments.length, methodParameterCount, method.getName(), method.getDeclaringClass().getName())).isEqualTo(methodParameterCount);
        Class<?>[] parameterTypes = method.getParameterTypes();
        int parameterIndex = 0;
        for (Object argument : arguments) {
            LangExtensions.assertThat(argument).throwing(RuntimeExceptionsFactory.newIllegalArgumentException("Argument [%1$s] is not assignable to parameter [%2$d] of type [%3$s]", argument, parameterIndex, parameterTypes[parameterIndex].getName())).isAssignableTo(parameterTypes[parameterIndex++]);
        }
        return arguments;
    }

    public Object[] getArguments() {
        return ArrayUtils.nullSafeArray(this.arguments);
    }

    public Class<?> getDeclaringClass() {
        return this.getMethod().getDeclaringClass();
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getTarget() {
        return this.target;
    }

    public <T> Optional<T> invoke() {
        return this.invoke(this.getTarget());
    }

    public <T> Optional<T> invoke(Object target) {
        Object resolvedTarget = this.resolveTarget(target);
        Method method = this.getMethod();
        try {
            return Optional.ofNullable(method.invoke(resolvedTarget, this.getArguments()));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MethodInvocationException(String.format("Failed to invoke method [%1$s] on target object [%2$s]", method.getName(), resolvedTarget), e);
        }
    }

    protected Object resolveTarget(Object target) {
        return Optional.ofNullable(target).orElseGet(this::getTarget);
    }

    public MethodInvocation makeAccessible() {
        this.getMethod().setAccessible(true);
        return this;
    }

    public MethodInvocation on(Object target) {
        Assert.isTrue(target != null || ModifierUtils.isStatic(this.getMethod()), "Method must be static if target is null", new Object[0]);
        this.target = target;
        return this;
    }

    public MethodInvocation passing(Object ... arguments) {
        this.arguments = this.validateArguments(this.getMethod(), arguments);
        return this;
    }
}

