/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.reflect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cp.elements.lang.ClassUtils;
import org.cp.elements.lang.reflect.MethodInterceptor;
import org.cp.elements.lang.reflect.ProxyService;
import org.cp.elements.util.ArrayUtils;
import org.cp.elements.util.stream.StreamUtils;

public abstract class ProxyFactory<T> {
    private Class<?>[] proxyInterfaces;
    private ClassLoader proxyClassLoader;
    private List<MethodInterceptor<T>> methodInterceptors = new ArrayList<MethodInterceptor<T>>();
    private T target;

    protected static <T> ProxyFactory<T> newProxyFactory() {
        return new ProxyFactory<T>(){

            @Override
            public boolean canProxy(Object target, Class[] proxyInterfaces) {
                return ProxyService.newProxyService().canProxy(target, proxyInterfaces);
            }

            @Override
            public <R> R newProxy(ClassLoader proxyClassLoader, T target, Class<?>[] proxyInterfaces, Iterable<MethodInterceptor<T>> methodInterceptors) {
                return (R)StreamUtils.stream(ProxyService.newProxyService()).filter(proxyFactory -> proxyFactory.canProxy(this.getTarget(), this.getProxyInterfaces())).findFirst().flatMap(proxyFactory -> Optional.of(proxyFactory.newProxy(this.getProxyClassLoader(), this.getTarget(), this.getProxyInterfaces(), this.getMethodInterceptors()))).orElse(this.getTarget());
            }
        };
    }

    public static <T> ProxyFactory<T> newProxyFactory(T target, Class<?> ... proxyInterfaces) {
        return ProxyFactory.newProxyFactory().proxy(target).implementing(proxyInterfaces);
    }

    protected static Class<?>[] resolveInterfaces(Object obj, Class<?> ... interfaces) {
        HashSet allImplementedInterfaces = new HashSet(ClassUtils.getInterfaces(obj));
        allImplementedInterfaces.addAll(StreamUtils.stream(ArrayUtils.nullSafeArray(interfaces, Class.class)).filter(ClassUtils::isInterface).collect(Collectors.toList()));
        return allImplementedInterfaces.toArray(new Class[allImplementedInterfaces.size()]);
    }

    public abstract boolean canProxy(Object var1, Class<?> ... var2);

    protected Iterable<MethodInterceptor<T>> getMethodInterceptors() {
        return Collections.unmodifiableList(this.methodInterceptors);
    }

    protected ClassLoader getProxyClassLoader() {
        return Optional.ofNullable(this.proxyClassLoader).orElseGet(() -> Thread.currentThread().getContextClassLoader());
    }

    public Class<?>[] getProxyInterfaces() {
        return ArrayUtils.nullSafeArray(this.proxyInterfaces, Class.class);
    }

    public T getTarget() {
        return this.target;
    }

    public ProxyFactory<T> adviseWith(MethodInterceptor<T> ... methodInterceptors) {
        Collections.addAll(this.methodInterceptors, ArrayUtils.nullSafeArray(methodInterceptors));
        return this;
    }

    public ProxyFactory<T> implementing(Class<?> ... proxyInterfaces) {
        this.proxyInterfaces = proxyInterfaces;
        return this;
    }

    public ProxyFactory<T> proxy(T target) {
        this.target = target;
        return this;
    }

    public ProxyFactory<T> using(ClassLoader proxyClassLoader) {
        this.proxyClassLoader = proxyClassLoader;
        return this;
    }

    public <R> R newProxy() {
        return this.newProxy(this.getProxyClassLoader(), this.getTarget(), this.getProxyInterfaces(), this.getMethodInterceptors());
    }

    protected abstract <R> R newProxy(ClassLoader var1, T var2, Class<?>[] var3, Iterable<MethodInterceptor<T>> var4);
}

