/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.reflect;

import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;
import org.cp.elements.lang.reflect.ProxyFactory;
import org.cp.elements.service.annotation.Service;
import org.cp.elements.service.support.ServiceSupport;
import org.cp.elements.util.stream.StreamUtils;

@Service
public final class ProxyService<T>
implements Iterable<ProxyFactory>,
ServiceSupport<ProxyFactory<T>> {
    private static ProxyService proxyServiceInstance;
    private final ServiceLoader<ProxyFactory> proxyFactoriesLoader = ServiceLoader.load(ProxyFactory.class);

    public static synchronized <T> ProxyService<T> newProxyService() {
        proxyServiceInstance = Optional.ofNullable(proxyServiceInstance).orElseGet(ProxyService::new);
        return proxyServiceInstance;
    }

    private ProxyService() {
    }

    public boolean canProxy(Object target, Class<?> ... proxyInterfaces) {
        return StreamUtils.stream(this).anyMatch(proxyFactory -> proxyFactory.canProxy(target, proxyInterfaces));
    }

    @Override
    public Iterator<ProxyFactory> iterator() {
        return this.proxyFactoriesLoader.iterator();
    }

    public void reload() {
        this.proxyFactoriesLoader.reload();
    }
}

