/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.lang.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.BooleanUtils;
import org.cp.elements.lang.ClassUtils;
import org.cp.elements.lang.Filter;
import org.cp.elements.lang.FluentApiExtension;
import org.cp.elements.lang.annotation.FluentApi;
import org.cp.elements.lang.reflect.FieldAccessException;
import org.cp.elements.lang.reflect.FieldNotFoundException;
import org.cp.elements.lang.reflect.MethodInvocationException;
import org.cp.elements.lang.reflect.MethodNotFoundException;
import org.cp.elements.lang.support.ComposableFilter;
import org.cp.elements.util.ComparatorUtils;
import org.cp.elements.util.stream.StreamUtils;

public abstract class ReflectionUtils
extends ClassUtils {
    public static Class[] getArgumentTypes(Object ... arguments) {
        Class[] argumentTypes = null;
        if (arguments != null) {
            argumentTypes = new Class[arguments.length];
            for (int index = 0; index < arguments.length; ++index) {
                argumentTypes[index] = ReflectionUtils.getClass(arguments[index]);
            }
        }
        return argumentTypes;
    }

    public static <T> T getValue(Class<?> type, String fieldName, Class<T> fieldType) {
        try {
            return ReflectionUtils.getValue(null, ReflectionUtils.getField(type, fieldName), fieldType);
        }
        catch (FieldNotFoundException e) {
            throw new IllegalArgumentException(String.format("Field with name (%1$s) does not exist on class type (%2$s)!", fieldName, type.getName()), e);
        }
    }

    public static <T> T getValue(Object obj, String fieldName, Class<T> fieldType) {
        try {
            return ReflectionUtils.getValue(obj, ReflectionUtils.getField(obj.getClass(), fieldName), fieldType);
        }
        catch (FieldNotFoundException e) {
            throw new IllegalArgumentException(String.format("Field with name (%1$s) does not exist on object of type (%2$s)!", fieldName, obj.getClass().getName()), e);
        }
    }

    public static <T> T getValue(Object target, Field field, Class<T> type) {
        try {
            boolean currentAccessible = field.isAccessible();
            field.setAccessible(true);
            Object value = field.get(target);
            field.setAccessible(currentAccessible);
            return type.cast(value);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FieldAccessException(String.format("Failed to get value of field (%1$s) from %2$s type (%3$s)!", field.getName(), BooleanUtils.toString(target == null, "class", "object of"), ReflectionUtils.getClassName(target)), e);
        }
    }

    public static void setField(Class<?> type, String fieldName, Object value) {
        try {
            ReflectionUtils.setField(null, ReflectionUtils.getField(type, fieldName), value);
        }
        catch (FieldNotFoundException e) {
            throw new IllegalArgumentException(String.format("Field with name (%1$s) does not exist on class type (%2$s)!", fieldName, type.getName()), e);
        }
    }

    public static void setField(Object obj, String fieldName, Object value) {
        try {
            ReflectionUtils.setField(obj, ReflectionUtils.getField(obj.getClass(), fieldName), value);
        }
        catch (FieldNotFoundException e) {
            throw new IllegalArgumentException(String.format("Field with name (%1$s) does not exist on object of type (%2$s)!", fieldName, obj.getClass().getName()), e);
        }
    }

    public static void setField(Object target, Field field, Object value) {
        try {
            Assert.isFalse(Modifier.isFinal(field.getModifiers()), new FieldAccessException(String.format("Cannot set the value of a final field (%1$s) on %2$s type (%3$s)!", field.getName(), BooleanUtils.toString(target == null, "class", "object of"), field.getDeclaringClass().getName())));
            boolean currentAccessible = field.isAccessible();
            field.setAccessible(true);
            field.set(target, value);
            field.setAccessible(currentAccessible);
        }
        catch (FieldAccessException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FieldAccessException(String.format("Failed to set field (%1$s) to value (%2$s) on %3$s type (%4$s)!", field.getName(), value, BooleanUtils.toString(target == null, "class", "object of"), field.getDeclaringClass().getName()), e);
        }
    }

    public static void invoke(Class<?> type, String methodName) {
        ReflectionUtils.invoke(type, methodName, null, null, Void.class);
    }

    public static void invoke(Class<?> type, String methodName, Object ... arguments) {
        ReflectionUtils.invoke(type, methodName, ReflectionUtils.getArgumentTypes(arguments), arguments, Void.class);
    }

    public static <T> T invoke(Class<?> type, String methodName, Class<T> returnType) {
        return ReflectionUtils.invoke(type, methodName, null, null, returnType);
    }

    public static <T> T invoke(Class<?> type, String methodName, Object[] arguments, Class<T> returnType) {
        return ReflectionUtils.invoke(type, methodName, ReflectionUtils.getArgumentTypes(arguments), arguments, returnType);
    }

    public static void invoke(Class<?> type, String methodName, Class<?>[] parameterTypes, Object ... arguments) {
        ReflectionUtils.invoke(null, ReflectionUtils.resolveMethod(type, methodName, parameterTypes, arguments, Void.class), arguments, Void.class);
    }

    public static <T> T invoke(Class<?> type, String methodName, Class<?>[] parameterTypes, Object[] arguments, Class<T> returnType) {
        try {
            return ReflectionUtils.invoke(null, ReflectionUtils.resolveMethod(type, methodName, parameterTypes, arguments, returnType), arguments, returnType);
        }
        catch (MethodNotFoundException e) {
            throw new IllegalArgumentException(String.format("No method with signature (%1$s) exists on class type (%2$s)!", ReflectionUtils.getMethodSignature(methodName, parameterTypes, returnType), type.getName()), e);
        }
    }

    public static void invoke(Object obj, String methodName) {
        ReflectionUtils.invoke(obj, methodName, null, null, Void.class);
    }

    public static void invoke(Object obj, String methodName, Object ... arguments) {
        ReflectionUtils.invoke(obj, methodName, ReflectionUtils.getArgumentTypes(arguments), arguments, Void.class);
    }

    public static <T> T invoke(Object obj, String methodName, Class<T> returnType) {
        return ReflectionUtils.invoke(obj, methodName, null, null, returnType);
    }

    public static <T> T invoke(Object obj, String methodName, Object[] arguments, Class<T> returnType) {
        return ReflectionUtils.invoke(obj, methodName, ReflectionUtils.getArgumentTypes(arguments), arguments, returnType);
    }

    public static void invoke(Object obj, String methodName, Class<?>[] parameterTypes, Object ... arguments) {
        ReflectionUtils.invoke(obj, ReflectionUtils.resolveMethod(obj.getClass(), methodName, parameterTypes, arguments, Void.class), arguments, Void.class);
    }

    public static <T> T invoke(Object obj, String methodName, Class<?>[] parameterTypes, Object[] arguments, Class<T> returnType) {
        try {
            return ReflectionUtils.invoke(obj, ReflectionUtils.resolveMethod(obj.getClass(), methodName, parameterTypes, arguments, returnType), arguments, returnType);
        }
        catch (MethodNotFoundException e) {
            throw new IllegalArgumentException(String.format("No method with signature (%1$s) exists on object of type (%2$s)!", ReflectionUtils.getMethodSignature(methodName, parameterTypes, returnType), obj.getClass().getName()), e);
        }
    }

    public static <T> T invoke(Object target, Method method, Object[] arguments, Class<T> returnType) {
        try {
            boolean currentAccessible = method.isAccessible();
            method.setAccessible(true);
            Object returnValue = method.invoke(target, arguments);
            method.setAccessible(currentAccessible);
            return returnType.cast(returnValue);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MethodInvocationException(String.format("Failed to invoke method (%1$s) on %2$s type (%3$s)!", ReflectionUtils.getMethodSignature(method), BooleanUtils.toString(target == null, "class", "object of"), method.getDeclaringClass().getName()), e);
        }
    }

    @FluentApi
    public static WithFields withFields(Field ... fields) {
        return new WithFields(fields);
    }

    @FluentApi
    public static WithMethods withMethods(Method ... methods) {
        return new WithMethods(methods);
    }

    public static class WithMethods
    extends WithExpression<Method> {
        public WithMethods(Method ... methods) {
            super((Member[])methods);
        }

        protected Method[] members(Class<?> type) {
            return type.getDeclaredMethods();
        }
    }

    public static class WithFields
    extends WithExpression<Field> {
        public WithFields(Field ... fields) {
            super((Member[])fields);
        }

        protected Field[] members(Class<?> type) {
            return type.getDeclaredFields();
        }

        @Override
        protected Set<Field> newMemberSet() {
            return new TreeSet<Field>(ComparatorUtils.nullSafeArgumentsComparator((field1, field2) -> {
                String fullyQualifiedFieldOneName = field1.getDeclaringClass().getName().concat(field1.getName());
                String fullyQualifiedFieldTwoName = field2.getDeclaringClass().getName().concat(field2.getName());
                return fullyQualifiedFieldOneName.compareTo(fullyQualifiedFieldTwoName);
            }));
        }
    }

    public static abstract class WithExpression<T extends Member>
    implements FluentApiExtension {
        private volatile boolean accepted = false;
        private final Filter<T> defaultFilter = obj -> obj != null;
        private Filter<T> filter;
        private final Set<T> members = this.newMemberSet();

        protected WithExpression(T ... members) {
            if (members != null) {
                Collections.addAll(this.members, members);
            }
        }

        protected Filter<T> getFilter() {
            return ComposableFilter.and(this.defaultFilter, this.filter);
        }

        protected Iterable<T> getMembers() {
            return this.members;
        }

        protected boolean accepts(T member) {
            boolean localAccepted = this.getFilter().accept(member);
            this.accepted |= localAccepted;
            return localAccepted;
        }

        public WithExpression<T> call(MemberCallback<T> callback) {
            StreamUtils.stream(this.getMembers()).filter(this::accepts).forEach(callback::with);
            return this;
        }

        public WithExpression<T> matching(Filter<T> filter) {
            this.filter = filter;
            return this;
        }

        protected abstract T[] members(Class<?> var1);

        protected Set<T> newMemberSet() {
            return new HashSet();
        }

        public WithExpression<T> on(Object obj) {
            return this.on(ClassUtils.getClass(obj));
        }

        public WithExpression<T> on(Class<?> type) {
            Assert.notNull(type, "The class type must not be null!", new Object[0]);
            while (type != null) {
                Collections.addAll(this.members, this.members(type));
                type = type.getSuperclass();
            }
            return this;
        }

        public WithExpression<T> throwing(RuntimeException e) {
            if (!this.accepted) {
                throw e;
            }
            return this;
        }
    }

    public static interface MethodCallback
    extends MemberCallback<Method> {
    }

    public static interface FieldCallback
    extends MemberCallback<Field> {
    }

    public static interface MemberCallback<T extends Member> {
        public void with(T var1);
    }
}

